% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CC_without_robScore_functions.R
\name{multiview_pam_gen}
\alias{multiview_pam_gen}
\title{Multiview PAM (K-medoids) generation}
\usage{
multiview_pam_gen(
  X,
  rep = 10,
  range.k = c(2, 5),
  is.distance = FALSE,
  method = "random",
  sample.set = NA
)
}
\arguments{
\item{X}{List of input data matrices of Sample x feature or distance matrices.
The length of \code{X} is equal to Nviews}

\item{rep}{number of repeats}

\item{range.k}{vector of minimum and maximum values for k \code{c(min, max)}}

\item{is.distance}{binary balue indicating if the input \code{X} is distance}

\item{method}{method for the choice of k at each repeat \code{c("random", "silhouette")}}

\item{sample.set}{vector of samples the clustering is being applied on. can be names or indices.
if \code{sample.set} is \code{NA}, it considers all the datasets have the same samples with the same order}
}
\value{
matrix of clusterings Nsample x (Nrepeat x Nviews)
}
\description{
Multiview PAM (K-medoids) generation
}
\details{
At each repeat, k is selected randomly or based on the best silhouette width from a discrete uniform distribution between range.k[1] and range.k[2].
Then PAM clustering is applied and result is returned.
}
\examples{
data = multiview_clusters (n = c(40,40,40), hidden.dim = 2, observed.dim = c(2,2,2),
sd.max = .1, sd.noise = 0, hidden.r.range = c(.5,1))
X_observation = data[["observation"]]
Clusters = multiview_pam_gen(X_observation)

}
