% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentroidImputationSetConcept.R
\name{drawCentroidImputationSet}
\alias{drawCentroidImputationSet}
\title{draw centroid of imputation set for 3 or 4 players}
\usage{
drawCentroidImputationSet(
  v,
  holdOn = FALSE,
  colour = NA,
  label = TRUE,
  name = "centroid of imputation set"
)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}

\item{holdOn}{draws in a existing plot}

\item{colour}{draws the geometric object (i.e. point or convex polyhedron) with this colour, all colour names can be seen with "colors()"}

\item{label}{activates the labels for the figure}

\item{name}{set a name for the label}
}
\value{
None.
}
\description{
drawCentroidImputationSet draws the centroid of the imputation set for 3 or 4 players.
}
\examples{
library(CoopGame)
v <-c(1,2,3,60,60,60,142)
drawCentroidImputationSet(v,colour="green")
}
\references{
Peleg B. and Sudhoelter P. (2007) \emph{Theory of cooperative games}, 2nd Edition, Springer, p. 20

Maschler M., Solan E. and Zamir S. (2013) \emph{Game Theory}, Cambridge University Press, p. 674

Osborne M.J. and Rubinstein A. (1994) \emph{A Course in Game Theory}, MIT Press, p. 278

Narahari Y. (2015)  \emph{Game Theory and Mechanism Design}, World Scientific Publishing, p. 407
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
