% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NucleolusDerivatives.R
\name{drawNucleolus}
\alias{drawNucleolus}
\title{Draw nucleolus for 3 or 4 players}
\usage{
drawNucleolus(v, holdOn = FALSE, colour = NA, label = TRUE, name = "Nucleolus")
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}

\item{holdOn}{draws in a existing plot}

\item{colour}{draws the geometric object (i.e. point or convex polyhedron) with this colour, all colour names can be seen with "colors()"}

\item{label}{activates the labels for the figure}

\item{name}{set a name for the label}
}
\value{
None.
}
\description{
drawNucleolus draws the nucleolus for 3 or 4 players.
}
\examples{
library(CoopGame)
v=c(0,0,0,1,1,0,3)
drawNucleolus(v) 

\donttest{
#Visualization for estate division problem from Babylonian Talmud with E=300,
#see e.g. seminal paper by Aumann & Maschler from 1985 on
#'Game Theoretic Analysis of a Bankruptcy Problem from the Talmud'
library(CoopGame)
v<-bankruptcyGameVector(n=3,d=c(100,200,300),E=300)
drawNucleolus(v)
}

}
\references{
Schmeidler D. (1969) "The nucleolus of a characteristic function game", SIAM Journal on applied mathematics 17(6), pp. 1163--1170

Kohlberg E. (1971) "On the nucleolus of a characteristic function game", SIAM Journal on applied mathematics 20(1), pp. 62--66

Kopelowitz A. (1967) "Computation of the kernels of simple games and the nucleolus of n-person games", Technical Report, Department of Mathematics, The Hebrew University of Jerusalem, 45 pages.

Megiddo N. (1974) "On the nonmonotonicity of the bargaining set, the kernel and the nucleolus of a game", SIAM Journal on applied mathematics 27(2), pp. 355--358

Peleg B. and Sudhoelter P. (2007) \emph{Theory of cooperative games}, 2nd Edition, Springer, pp. 82--86
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}
}
