% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PublicHelpValueConcept.R
\name{drawPublicHelpValue}
\alias{drawPublicHelpValue}
\title{Draw Public Help value Theta for 3 or 4 players}
\usage{
drawPublicHelpValue(
  v,
  holdOn = FALSE,
  colour = NA,
  label = TRUE,
  name = "Normalized Public Help Value"
)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}

\item{holdOn}{draws in a existing plot}

\item{colour}{draws the geometric object (i.e. point or convex polyhedron) with this colour, all colour names can be seen with "colors()"}

\item{label}{activates the labels for the figure}

\item{name}{set a name for the label}
}
\value{
None.
}
\description{
drawPublicHelpValue draws the (normalized) Public Help value Theta for 3 or 4 players.
}
\examples{
library(CoopGame)
v=c(0,0,0,1,1,0,1)
drawPublicHelpValue(v) 
}
\references{
Bertini C. and Stach I. (2015) "On Public Values and Power Indices", Decision Making in Manufacturing and Services 9(1), pp. 9--25
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
