% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGainingCoalitions.R
\name{getGainingCoalitions}
\alias{getGainingCoalitions}
\title{Compute gaining coalitions of a TU game}
\usage{
getGainingCoalitions(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
A data frame containing all gaining coalitions.
}
\description{
The function getGainingCoalitions identifies all 
gaining coalitions.
Coalition \code{S} is a gaining coalition if there holds: v(S) > 0
}
\examples{
library(CoopGame)
getGainingCoalitions(v=c(0,0,0,2,0,2,3))

\donttest{
library(CoopGame)
v <- c(1,2,3,4,0,0,11)
getGainingCoalitions(v)
# Output:
#    V1 V2 V3 cVal
# 1  1  0  0    1
# 2  0  1  0    2
# 3  0  0  1    3
# 4  1  1  0    4
# 7  1  1  1   11
}

}
\references{
Bertini C. and Stach I. (2015) "On Public Values and Power Indices", Decision Making in Manufacturing and Services 9(1), pp. 9--25
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
