% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GloveGame.R
\name{gloveGameValue}
\alias{gloveGameValue}
\title{Compute value of a coalition for a glove game}
\usage{
gloveGameValue(S, L, R)
}
\arguments{
\item{S}{numeric vector with coalition of players}

\item{L}{numeric vector of players owning one left-hand glove each}

\item{R}{numeric vector of players owning one right-hand glove each}
}
\value{
Number of matched pairs of gloves for given coalition \code{S}
}
\description{
\strong{Coalition value for a specified glove game: }\cr
For further information see \link{gloveGame}
}
\examples{
library(CoopGame)
gloveGameValue(S=c(1,2), L=c(1,2), R=c(3)) 

}
\references{
Peters H. (2015)  \emph{Game Theory: A Multi-Leveled Approach}, 2nd Edition, Springer, pp. 155--156
}
\author{
Alexandra Tiukkel

Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
