% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WebersetConcept.R
\name{webersetVertices}
\alias{webersetVertices}
\title{Compute vertices of Weber Set}
\usage{
webersetVertices(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
rows of the matrix are the vertices of the Weber Set
}
\description{
Calculates the Weber Set for given game vector with n players.
}
\examples{
library(CoopGame)
webersetVertices(c(0,0,0,1,1,1,2))

\donttest{
#Example of a 3-player TU game (with a Weber Set with 6 vertices)
library(CoopGame)
v = c(0,1,2,3,4,5,6)
webersetVertices(v)

#Example of a 4-player TU game (with a Weber Set with 14 vertices)
library(CoopGame)
v = c(5,2,4,7,15,15,15,15,15,15,20,20,20,20,35)
webersetVertices(v)
}

}
\references{
Weber R.J. (1988) "Probabilistic values for games". In: Roth A.E. (Ed.), The Shapley Value. Essays in in honor of Lloyd S. Shapley, Cambridge University Press, pp. 101--119

Peters H. (2015)  \emph{Game Theory: A Multi-Leveled Approach}, 2nd Edition, Springer, pp. 327--329
}
\author{
Anna Merkle

Franz Mueller

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
