% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copc1.r
\name{genLatentY}
\alias{genLatentY}
\title{Generation of data from the copula-based Markov model of order one}
\usage{
genLatentY(cop="Gaussian",theta,N,MARGIN.inv=qnorm,...)
}
\arguments{
\item{cop}{the choice of copula function.
There are currently five available copula funcitons,
including Clayton copula, Gaussian copula, Gumbel copula, Joe copula and Frank copula.
Specify one from "Clayton","Gaussian","Gumbel","Joe" and "Frank".
The default is "Gaussian".}

\item{theta}{the copula parameter.}

\item{N}{the length of the latent response.}

\item{MARGIN.inv}{the inverse marginal distribution function of the latent time series.
The default is \code{qnorm(p,mean=0,sd=1)}, i.e., the standard normal marginal.}

\item{...}{additional parameters for the inverse marginal distribution funcion of the latent time series.}
}
\value{
\code{genLatentY} returns a Nx1 vector of the latent response variable Y*
}
\description{
Generate the latent response variable from the assumed copula-based
Markov model in Li, Tang and Wang (2018).
}
\references{
Li, F., Tang, Y. and Wang, H. (2018) Copula-based Semiparametric Analysis for Time Series Data with Detection Limits, technical report.
}
