% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/B_splines_est.R
\name{get_tau}
\alias{get_tau}
\title{Get a Specific \eqn{\tau_{i}}.}
\usage{
get_tau(i, p, m, kVec)
}
\arguments{
\item{i}{The knot index (\eqn{-p} through \eqn{m + p + 1}).}

\item{p}{The order of the splines.}

\item{m}{The number of nonboundary knots.}

\item{kVec}{Knot vector - see \link{generate_knots}.}
}
\value{
The numerical value of \eqn{\tau_{i}.}
}
\description{
A helper function that transforms the knots from \link{generate_knots} into the following form:
For \eqn{i = -p , -p + 1, \dots , -2, -1 , m + 2, m + 3, \dots , m + p , m + p + 1,} it is equal to \eqn{\tau_{i} = i / (m + 1)}, and for \eqn{i = 0, \dots , m + 1,} it is \eqn{\tau_{i} = \kappa_{i}.}
See Choi, Li & Wang (2013) page 615 for details.
This is a helper function of \link{get_taus}.
}
\examples{
kVec <- generate_knots(2)
get_tau(1, 3, 2, kVec)
}
\references{
Choi, I., Li, B. & Wang, X. (2013). Nonparametric Estimation of Spatial and Space-Time Covariance Function. JABES 18, 611-630. https://doi.org/10.1007/s13253-013-0152-z
}
