% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corrected_standard_estimator.R
\name{kernel_est}
\alias{kernel_est}
\title{Kernel Correction for an Estimated Autocovariance Function.}
\usage{
kernel_est(
  estCov,
  kernel_name,
  kernel_params = c(),
  N_T = 0.1 * length(estCov),
  maxLag = length(estCov) - 1,
  type = "autocovariance",
  custom_kernel = FALSE
)
}
\arguments{
\item{estCov}{A vector whose values are an estimate autocovariance function.}

\item{kernel_name}{The name of the \link{kernel} function to be used. Possible values are:
gaussian, exponential, wave, rational_quadratic, spherical, circular, bessel_j, matern, cauchy.}

\item{kernel_params}{A vector of parameters of the kernel function. See \link{kernel} for parameters.
In the case of gaussian, wave, rational_quadratic, spherical and circular, \code{N_T} takes the place of \eqn{\theta}.
For kernels that require parameters other than \eqn{\theta}, such as the Matern kernel, those parameters are passed.}

\item{N_T}{The range at which the kernel function vanishes at. Recommended to be \eqn{0.1 N} when considering all lags. This parameter may be large for a lag small estimation lag.}

\item{maxLag}{An optional parameter that determines the maximum lag to compute the estimated autocovariance function at. Defaults to \code{length(estCov) - 1}.}

\item{type}{Compute either the 'autocovariance' or 'autocorrelation'. Defaults to 'autocovariance'.}

\item{custom_kernel}{If a custom kernel is to be used or not. Defaults to \code{FALSE}. See the examples of \link{corrected_est} for usage.}
}
\value{
A vector whose values are the kernel corrected autocovariance estimates.
}
\description{
This function applies kernel correction to an estimated autocovariance function,
\deqn{\widehat{C}_{T}^{(a)}(h) = \widehat{C}(h) a_{T}(h),} where \eqn{a_{T}(h) := a(h / N_{T}).}
It uses a kernel \eqn{a(\cdot)} which decays or vanishes to zero (depending on the type of kernel) where \eqn{a(0) = 1.}
The rate or value at which the kernel vanishes is \eqn{N_{T}}, which is recommended to be of order \eqn{0.1 N}, where \eqn{N} is the length of the observation window, however, one may need to play with this value.
}
\examples{
X <- rnorm(1000)
Y <- c(X[1], X[2])
for(i in 3:length(X)) { Y[i] <- X[i] - 0.3*X[i - 1] - 0.6*X[i - 2] }
cov_est <- standard_est(Y)
plot(cov_est)
plot(kernel_est(cov_est,
     "bessel_j", kernel_params=c(0, 1), N_T=0.2*length(Y)))
}
