% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CovTest1.2014Srivastava.R
\name{CovTest1.2014Srivastava}
\alias{CovTest1.2014Srivastava}
\title{One-Sample Covariance Test by Srivastava, Yanagihara, and Kubokawa (2014)}
\usage{
CovTest1.2014Srivastava(data, Sigma0 = diag(ncol(data)), alpha = 0.05)
}
\arguments{
\item{data}{an \eqn{(n\times p)} data matrix where each row is an observation.}

\item{Sigma0}{a \eqn{(p\times p)} given covariance matrix.}

\item{alpha}{level of significance.}
}
\value{
a named list containing \describe{
\item{statistic}{a test statistic value.}
\item{threshold}{rejection criterion to be compared against test statistic.}
\item{reject}{a logical; \code{TRUE} to reject null hypothesis, \code{FALSE} otherwise.}
}
}
\description{
Given data, it performs 1-sample test for Covariance where
the null hypothesis is
\deqn{H_0 : \Sigma_n = \Sigma_0}
where \eqn{\Sigma_n} is the covariance of data model and \eqn{\Sigma_0} is a
hypothesized covariance based on a procedure proposed by Srivastava, Yanagihara, and Kubokawa (2014).
}
\examples{
\dontrun{
## generate data from multivariate normal with trivial covariance.
pdim = 5
data = matrix(rnorm(10*pdim), ncol=pdim)

## run the test
CovTest1.2014Srivastava(data)
}

}
\references{
\insertRef{srivastava_tests_2014}{CovTools}
}
