% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{exp_input}
\alias{exp_input}
\title{A data frame of expected ERCC1 and ERCC2 ratios}
\format{
A data frame with 92 rows and 4 columns: Each row represents an ERCC
    transcript.  Columns are described below:
\describe{
  \item{ercc_id}{ERCC spike-in mRNA Ids (ERCC-00002 -- ERCC-00171)}
  \item{subgroup}{ERCC subgroups (A -- D)}
  \item{ercc1_conc}{ERCC1 concentration (0.014 -- 30,000)}
  \item{ercc2_conc}{ERCC2 concentration (0.007 -- 30,000)}
  \item{expected_fc_ratio}{Expected fold change ratio (.5 -- 4)}
  \item{expected_lfc_ratio}{Expected log2 fold change ratio (-1 -- 2)}
 }
}
\usage{
exp_input
}
\description{
A data frame that contains the expected spike in ERCC data.  This data can be obtained
from 'ERCC Controls Analysis' manual located on Thermo Fisher's ERCC RNA
Spike-In Mix product
[page](https://assets.thermofisher.com/TFS-Assets/LSG/manuals/cms_095046.txt).
The 'exp_input' data frame mirrors the fields shown in the ERCC manual.
For the LCPM cutoff calculation, the last column of the log2 expected fold
change ratios are used.  Ensure that this column is titled
"expected_lfc_ratio". See the example code below for formatting the data.
}
\examples{
# Order rows by ERCC ID and assign to rownames.
exp_input = exp_input[order(exp_input$ercc_id), ]
rownames(exp_input) = exp_input$ercc_id

}
\keyword{datasets}
