% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cumGainsChart.R
\name{cumGainsChart}
\alias{cumGainsChart}
\title{Plot a cumulative gains chart}
\usage{
cumGainsChart(predTest, depTest, resolution = 1/10)
}
\arguments{
\item{predTest}{Vector with predictions (real-valued or discrete)}

\item{depTest}{Vector with true class labels}

\item{resolution}{Value for the determination of percentile intervals. Default 1/10 (10\%).}
}
\description{
Visualize gain through a cumulative gains chart.
}
\examples{
## Load response modeling predictions
data("response")
## Apply cumGainschart function to visualize cumulative gains of a customer response model
cumGainsChart(response$test[,2],response$test[,1])

}
\references{
Linoff, G.S. and Berry, M.J.A (2011): "Data Mining Techniques: For Marketing, Sales, and
Customer Relationship Management - Third Edition". John Wiley & Sons.
}
\seealso{
\code{\link{topDecileLift}}, \code{\link{liftIndex}}, \code{\link{liftChart}}
}
\author{
Koen W. De Bock, \email{kdebock@audencia.com}
}
