% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cumGainsTable.R
\name{cumGainsTable}
\alias{cumGainsTable}
\title{Calculates cumulative gains table}
\usage{
cumGainsTable(predTest, depTest, resolution = 1/10)
}
\arguments{
\item{predTest}{Vector with predictions (real-valued or discrete)}

\item{depTest}{Vector with true class labels}

\item{resolution}{Value for the determination of percentile intervals. Default 1/10 (10\%).}
}
\value{
A gain percentage table.
}
\description{
Calculates a cumulative gains (cumulative lift) table, showing for different percentiles
of predicted scores the percentage of customers with the behavior or characterstic of
interest is reached.
}
\examples{
## Load response modeling predictions
data("response")
## Apply cumGainsTable function to obtain cumulative gains table for test sample results
## and print results
cgt<-cumGainsTable(response$test[,2],response$test[,1])
print(cgt)

}
\references{
Linoff, G.S. and Berry, M.J.A (2011): "Data Mining Techniques: For Marketing, Sales, and
Customer Relationship Management - Third Edition". John Wiley & Sons.
}
\seealso{
\code{\link{topDecileLift}}, \code{\link{liftIndex}}, \code{\link{liftChart}}
}
\author{
Koen W. De Bock, \email{kdebock@audencia.com}
}
