% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAISIE_rates.R
\name{calc_peak}
\alias{calc_peak}
\title{Calculates the peak of ontogeny curve (beta function)}
\usage{
calc_peak(total_time, area_pars)
}
\arguments{
\item{total_time}{Numeric defining the length of the simulation in time
units.}

\item{area_pars}{A named list containing area and sea level parameters as
created by \code{\link{create_area_pars}()}:
\itemize{
  \item{[1]: maximum area}
  \item{[2]: current area}
  \item{[3]: value from 0 to 1 indicating where in the island's history the
  peak area is achieved}
  \item{[4]: total island age}
  \item{[5]: amplitude of area fluctuation from sea level}
  \item{[6]: frequency of sine wave of area change from sea level}
  \item{[7]: angle of the slope of the island}
}}
}
\value{
numeric
}
\description{
Calculates the peak of ontogeny curve (beta function)
}
\keyword{internal}
