% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DALSM_additive.R
\name{DALSM_additive}
\alias{DALSM_additive}
\title{Extraction of the estimated additive terms in a \code{\link{DALSM.object}}}
\usage{
DALSM_additive(obj.DALSM, ngrid=101,
       true.loc=NULL, true.disp=NULL, ci.level=NULL,
       verbose=FALSE)
}
\arguments{
\item{obj.DALSM}{a \code{\link{DALSM.object}}}

\item{ngrid}{(optional) grid size of covariate values where the additive terms are calculated (default: 101).}

\item{true.loc}{(optional) list of functions containing the 'true' additive terms in the location sub-model.}

\item{true.disp}{(optional) list of functions containing the 'true' additive terms in the dispersion sub-model.}

\item{ci.level}{(optional) level of credible intervals.}

\item{verbose}{logical indicating whether the computed corverages should be printed out (default: TRUE).}
}
\value{
It returns an invisible list containing:
\itemize{
\item{\code{J1} : \verb{ }}{number of additive terms in the location sub-model.}
\item{\code{labels.loc} : \verb{ }}{labels of the additive terms in the location sub-model.}
\item{\code{f.loc.grid} : \verb{ }}{list of length \code{J1} with, for each additive term, a list of length 3 with elements 'x': a vector of \code{ngrid} values for the covariate ; 'y.mat': a matrix with 3 columns (est,low,up) giving the additive term and its pointwise credible region ; se: the standard error of the additive term on the x-grid.}
\item{\code{f.loc} : \verb{ }}{a list of length \code{J1} with, for each additive term <x>, a list with f.loc$x: a function computing the additive term f.loc(x) for a given covariate value 'x' ; attributes(f.loc$x): support, label, range.}
\item{\code{se.loc} : \verb{ }}{a list of length \code{J1} with, for each additive term <x>, a list with se.loc$x: a function computing the s.e. of f(x) for a given covariate value 'x' ; attributes(se.loc$x): support, label, range.}
\item{\code{coverage.loc} : \verb{ }}{if \code{true.loc} is provided: a vector of length \code{J1} giving the average effective coverage of pointwise credible intervals for each of the additive terms in the location sub-model.}
\item{\code{J2} : \verb{ }}{number of additive terms in the dispersion sub-model.}
\item{\code{labels.disp} : \verb{ }}{labels of the additive terms in the dispersion sub-model.}
\item{\code{f.disp.grid} : \verb{ }}{list of length \code{J2} with, for each additive term, a list of length 3 with elements 'x': a vector of \code{ngrid} values for the covariate ; 'y.mat': a matrix with 3 columns (est,low,up) giving the additive term and its pointwise credible region ; se: the standard error of the additive term on the x-grid.}
\item{\code{f.disp} : \verb{ }}{a list of length \code{J2} with, for each additive term <x>, a list with f.disp$x: a function computing the additive term f.disp(x) for a given covariate value 'x' ; attributes(f.disp$x): support, label, range.}
\item{\code{se.disp} : \verb{ }}{a list of length \code{J2} with, for each additive term <x>, a list with se.disp$x: a function computing the s.e. of f(x) for a given covariate value 'x' ; attributes(se.disp$x): support, label, range.}
\item{\code{coverage.disp} : \verb{ }}{if <true.disp> is provided: a vector of length \code{J2} giving the average effective coverage of pointwise credible intervals for each of the additive terms in the dispersion sub-model.}
}
}
\description{
Extract the estimated additive terms with their standard errors from a \code{\link{DALSM.object}} resulting from the fit of a \code{\link{DALSM}} model.
In addition to the estimated functions in the location and dispersion submodels, their values on a regular grid covering the observed covariate values
are reported together with credible intervals. The mean effective coverage of these pointwise credible intervals
for the additive terms with respect to given (optional) reference functions (such as the ones for the 'true' additive terms used
to generate data in a simulation study) can also be computed.
}
\examples{
require(DALSM)
data(DALSM_IncomeData)
resp = DALSM_IncomeData[,1:2]
fit = DALSM(y=resp,
            formula1 = ~twoincomes+s(age)+s(eduyrs),
            formula2 = ~twoincomes+s(age)+s(eduyrs),
            data = DALSM_IncomeData)
obj = DALSM_additive(fit)
str(obj)

## Visualize the estimated additive terms for Age
## ... in the location submodel
with(obj$f.loc.grid$age, matplot(x,y.mat,
                                 xlab="Age",ylab="f.loc(Age)",
                                 type="l",col=1,lty=c(1,2,2)))
## ... and in the dispersion submodel
with(obj$f.disp.grid$age, matplot(x,y.mat,
                                 xlab="Age",ylab="f.disp(Age)",
                                 type="l",col=1,lty=c(1,2,2)))
## Also report their values for selected age values
obj$f.loc$age(c(30,40,50)) ; obj$f.disp$age(c(30,40,50))
## ... together with their standard errors
obj$se.loc$age(c(30,40,50)) ; obj$se.disp$age(c(30,40,50))
}
\references{
Lambert, P. (2021). Fast Bayesian inference using Laplace approximations
in nonparametric double additive location-scale models with right- and
interval-censored data.
\emph{Computational Statistics and Data Analysis}, 161: 107250.
<doi:10.1016/j.csda.2021.107250>
}
\seealso{
\code{\link{DALSM.object}}, \code{\link{DALSM}}, \code{\link{print.DALSM}}, \code{\link{plot.DALSM}}.
}
\author{
Philippe Lambert \email{p.lambert@uliege.be}
}
