% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densLPS_object.R
\name{densLPS.object}
\alias{densLPS.object}
\title{Object generated by function \code{densityLPS}}
\value{
An object returned by \code{\link{densityLPS}} has the following elements:
Essential part:
\itemize{
\item{\code{converged} : \verb{ }}{logical convergence indicator.}
\item{\code{ddist} : \verb{ }}{fitted density function.}
\item{\code{Hdist} : \verb{ }}{fitted cumulative hazard function.}
\item{\code{hdist} : \verb{ }}{fitted hazard function.}
\item{\code{pdist} : \verb{ }}{fitted cumulative distribution function.}
\item{\code{ymin, ymax} : \verb{ }}{assumed values for the support of the distribution.}
\item{\code{phi} : \verb{ }}{estimated B-spline coefficients for the log-hazard of the error distribution.}
\item{\code{U.phi} : \verb{ }}{score of the Lagrangian G(\eqn{\phi|\omega}).}
\item{\code{tau}, \code{ltau} : \verb{ }}{selected penalty parameter and its logarithm.}
\item{\code{est} : \verb{ }}{vector containing the estimated/selected (\eqn{\phi,\log\tau}) parameters.}
\item{\code{fixed.phi} : \verb{ }}{logical indicating whether the spline parameters were given fixed values or estimated from the data.}
\item{\code{phi.ref} : \verb{ }}{reference values for the spline parameters with respect to which \eqn{\phi} is compared during penalization.}
\item{\code{BWB} : \verb{ }}{Hessian for \eqn{\phi} without the penalty contribution.}
\item{\code{Prec} : \verb{ }}{Hessian or posterior precision matrix for \eqn{\phi}.}
\item{\code{Fisher} : \verb{ }}{Fisher information for \eqn{\phi}.}
\item{\code{bins, ugrid, du} : \verb{ }}{bins (of width 'du') and with midpoints 'ugrid' partitioning the support of the density.}
\item{\code{h.grid, H.grid, dens.grid} : \verb{ }}{hazard, cumulative hazard and density values at the grid midpoints 'ugrid'.}
\item{\code{h.bins, H.bins, dens.bins} : \verb{ }}{hazard, cumulative hazard and density values at the bin limits 'bins'.}
\item{\code{expected} : \verb{ }}{expected number of observations within each bin.}
\item{\code{Finfty} : \verb{ }}{integrated density value over the considered support.}
\item{\code{Mean0, Var0} : \verb{ }}{when specified, constrained mean and variance values during estimation.}
\item{\code{mean.dist, var.dist} : \verb{ }}{mean and variance of the fitted density.}
\item{\code{method} : \verb{ }}{method used for penaly selection: "evidence" (by maximizing the marginal posterior for \eqn{\tau}) or "Schall" (Schall's method).}
\item{\code{ed} : \verb{ }}{effective number of (spline) parameters.}
\item{\code{iterations} : \verb{ }}{total number of iterations necessary for convergence.}
\item{\code{elapsed.time} : \verb{ }}{time required for convergence.}
}
Additional elements:
the content of the \link{Dens1d.object} used when \link{densityLPS} was called.
}
\description{
An object returned by function \code{\link{densityLPS}}: this is a list
with various components related to the estimation of a density with given mean and variance from potentially right- or interval-censored data using Laplace P-splines.
}
\references{
Lambert, P. (2021). Fast Bayesian inference using Laplace approximations
in nonparametric double additive location-scale models with right- and
interval-censored data.
\emph{Computational Statistics and Data Analysis}, 161: 107250.
<doi:10.1016/j.csda.2021.107250>
}
\seealso{
\code{\link{densityLPS}}, \code{\link{DALSM}}
}
\author{
Philippe Lambert \email{p.lambert@uliege.be}
}
