% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.DALSM.R
\name{plot.DALSM}
\alias{plot.DALSM}
\title{Plot visual information on a \code{DALSM.object}}
\usage{
\method{plot}{DALSM}(x,
       mfrow.loc=NULL, mfrow.disp=NULL,
       nx=101, equal.ylims=TRUE, true.loc=NULL,true.disp=NULL, ci.level=NULL,
       error.lim = NULL, add.residuals=FALSE, true.derr=NULL, new.dev=TRUE, ...)
}
\arguments{
\item{x}{a \code{\link{DALSM.object}}.}

\item{mfrow.loc}{(optional) window layout to plot the additive terms for location.}

\item{mfrow.disp}{(optional) window layout to plot the additive terms for dispersion.}

\item{nx}{(optional) number of points to make the plots for the fitted additive terms (default: 101).}

\item{equal.ylims}{logical indicating if the same y-limits must be used when plotting the fitted additive terms (default: TRUE).}

\item{true.loc}{(optional) list of functions to be superposed to the corresponding estimated additive terms in the location submodel (default: NULL).}

\item{true.disp}{(optional) list of functions to be superposed to the corresponding estimated additive terms in the dispersion submodel (default: NULL).}

\item{ci.level}{(optional) nominal level for the plotted pointwise credible intervals (default: x$ci.level).}

\item{error.lim}{(optional) plotting interval for the estimated standardized error density in the DALSM model (default: support of the fitted standardized error density).}

\item{add.residuals}{logical requesting to add the (possibly censored) standardized residuals to the plot of the fitted standardized error density (default: FALSE).}

\item{true.derr}{(optional) density function to superpose to the estimated standardized error density when plotting (default: NULL).}

\item{new.dev}{(optional) logical indicating whether a new plotting device must be opened for each graph (default: TRUE).}

\item{...}{additional generic plotting arguments.}
}
\value{
In addition to the plots, an invisible list containing the following is returned:
\itemize{
\item{\code{J1} : \verb{ }}{number of additive terms in the location sub-model.}
\item{\code{x.loc} : \verb{ }}{a \code{nx} by \code{J1} matrix containing a regular grid of \code{nx} covariate values where the corresponding additive term in location is evaluated.}
\item{\code{f.loc} : \verb{ }}{a \code{nx} by \code{J1} matrix containing the \code{J1} fitted location additive terms evaluated at \code{x.loc}.}
\item{\code{se.loc} : \verb{ }}{a \code{nx} by \code{J1} matrix containing the the pointwise standard errors of the fitted location additive terms evaluated at \code{x.loc}.}
\item{\code{J2} : \verb{ }}{number of additive terms in the dispersion sub-model.}
\item{\code{x.disp} : \verb{ }}{a \code{nx} by \code{J2} matrix containing a regular grid of \code{nx} covariate values where the corresponding additive term in dispersion is evaluated.}
\item{\code{f.disp} : \verb{ }}{a \code{nx} by \code{J2} matrix containing the \code{J2} fitted dispersion additive terms evaluated at \code{x.disp}.}
\item{\code{se.disp} : \verb{ }}{a \code{nx} by \code{J2} matrix containing the pointwise standard errors of the fitted dispersion additive terms evaluated at \code{x.disp}.}
}
}
\description{
Visualize the estimated additive terms and error density corresponding to a Double Additive Location-Scale Model (DALSM) object.
}
\details{
Plot the fitted additive terms and the estimated standardized error density contained in the \code{\link{DALSM.object}} \code{x}.
}
\examples{
require(DALSM)
data(DALSM_IncomeData)
resp = DALSM_IncomeData[,1:2]
fit = DALSM(y=resp,
            formula1 = ~twoincomes+s(age)+s(eduyrs),
            formula2 = ~twoincomes+s(age)+s(eduyrs),
            data = DALSM_IncomeData)
plot(fit)

}
\references{
Lambert, P. (2021). Fast Bayesian inference using Laplace approximations
in nonparametric double additive location-scale models with right- and
interval-censored data.
\emph{Computational Statistics and Data Analysis}, 161: 107250.
<doi:10.1016/j.csda.2021.107250>
}
\seealso{
\code{\link{DALSM}}, \code{\link{DALSM.object}}, \code{\link{print.DALSM}}
}
\author{
Philippe Lambert \email{p.lambert@uliege.be}
}
