% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.densLPS.R
\name{plot.densLPS}
\alias{plot.densLPS}
\title{Plot the density estimate in a \code{densLPS.object}}
\usage{
\method{plot}{densLPS}(x,
       xlim=range(fit$bins),breaks=NULL,hist=FALSE,histRC=FALSE,
       xlab="",ylab="Density",main="",...)
}
\arguments{
\item{x}{a \code{\link{densLPS.object}}.}

\item{xlim}{interval of values where the density should be plotted.}

\item{breaks}{(Optional) breaks for the histogram of the observed residuals.}

\item{hist}{Logical (Default: FALSE) indicating whether the histogram of the (pseudo-) data should be plotted with the estimated density.}

\item{histRC}{Logical (Default: FALSE) indicating whether the histogram of the right-censored residuals should be highlighted.}

\item{xlab}{Optional label for the x-axis (Defaut: empty).}

\item{ylab}{Optional label for the y-axis (Default: "Density").}

\item{main}{Plot main title (Default: "").}

\item{...}{Optional additional plot parameters.}
}
\value{
No returned value (just plots).
}
\description{
Plot the density estimate obtained by \code{densityLPS} from censored data with given mean and variance.
}
\examples{
require(DALSM)

## Example 1: density estimation from simulated IC data
n = 500 ## Sample size
x = 3 + rgamma(n,10,2) ## Exact generated data
width = runif(n,1,3) ## Width of the IC data (mean width = 2)
w = runif(n) ## Positioning of the exact data within the interval
xmat = cbind(x-w*width,x+(1-w)*width) ## Generated IC data
head(xmat)
obj.data = Dens1d(xmat,ymin=0) ## Prepare the data for estimation
## Density estimation with fixed mean and variance
obj = densityLPS(obj.data,Mean0=3+10/2,Var0=10/4)
plot(obj, hist=TRUE) ## Histogram of the pseudo-data with the density estimate
curve(dgamma(x-3,10,2), ## ... compared to the true density (in red)
      add=TRUE,col="red",lwd=2,lty=2)
legend("topright",col=c("black","red","grey"),lwd=c(2,2,10),lty=c(1,2,1),
       legend=c("Fitted density","True density","Pseudo-data"),bty="n")
print(obj) ## ... with summary statistics

## Example 2: estimation of the error density in a DALSM model
data(DALSM_IncomeData)
resp = DALSM_IncomeData[,1:2]
fit = DALSM(y=resp,
            formula1 = ~twoincomes+s(age)+s(eduyrs),
            formula2 = ~twoincomes+s(age)+s(eduyrs),
            data = DALSM_IncomeData)
plot(fit$derr, hist=TRUE)  ## Plot the estimated error density
legend("topright",col=c("black","grey"),lwd=c(2,10),lty=c(1,1),
       legend=c("Estimated error density","Pseudo-residuals"),bty="n")
print(fit$derr) ## ... and provide summary statistics for it
}
\references{
Lambert, P. (2021). Fast Bayesian inference using Laplace approximations
in nonparametric double additive location-scale models with right- and
interval-censored data.
\emph{Computational Statistics and Data Analysis}, 161: 107250.
<doi:10.1016/j.csda.2021.107250>
}
\seealso{
\code{\link{densLPS.object}}, \code{\link{print.densLPS}}, \code{\link{densityLPS}}.
}
\author{
Philippe Lambert \email{p.lambert@uliege.be}
}
