% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRegion.R
\name{plotRegion}
\alias{plotRegion}
\title{Plot a credible region for a curve together with its point estimates}
\usage{
plotRegion(x,mat,
       add=FALSE, xlim=range(x), ylim=range(mat),
       lwd=2, xlab="", ylab="", main="", ...)
}
\arguments{
\item{x}{vector of values where the curve is evaluated.}

\item{mat}{cbind(f.hat,f.low,f.up) is a matrix containing the point estimates <f.hat> and the liming values <f.low> and <f.up> for the credible region.}

\item{add}{Logical indicating if the plot must be added to the active plot (Default: FALSE).}

\item{xlim}{range of <x> values for which the plot should be provided.}

\item{ylim}{range of curve values that should be considered for the plot.}

\item{lwd}{line width for the plot (Default: 2).}

\item{xlab}{x-label.}

\item{ylab}{y-label.}

\item{main}{main title.}

\item{...}{optional plotting parameters.}
}
\value{
No returned value (just a plot)
}
\description{
Plot a credible region (in grey) for a curve together with its point estimates.
}
\examples{
require(DALSM)
data(DALSM_IncomeData)
resp = DALSM_IncomeData[,1:2]
fit = DALSM(y=resp,
            formula1 = ~twoincomes+s(age)+s(eduyrs),
            formula2 = ~twoincomes+s(age)+s(eduyrs),
            data = DALSM_IncomeData)
obj = DALSM_additive(fit)
## par(mfrow=c(1,2),mar=c(4,5,1,1))
with(obj$f.loc.grid$age, plotRegion(x, y.mat,
     xlab="age", ylab=expression('f'[1]^{~mu}*(age))))
with(obj$f.disp.grid$age, plotRegion(x, y.mat,
     xlab="age", ylab=expression('f'[1]^{~sigma}*(age))))
}
\references{
Lambert, P. (2021). Fast Bayesian inference using Laplace approximations
in nonparametric double additive location-scale models with right- and
interval-censored data.
\emph{Computational Statistics and Data Analysis}, 161: 107250.
<doi:10.1016/j.csda.2021.107250>
}
\seealso{
\code{\link{DALSM}}, \code{\link{DALSM.object}}.
}
\author{
Philippe Lambert \email{p.lambert@uliege.be}
}
