% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AICc.R
\name{AICc}
\alias{AICc}
\title{Corrected AIC for linear models}
\usage{
AICc(model)
}
\arguments{
\item{model}{A fitted `lm` object.}
}
\value{
The numeric value of of corrected AIC for the supplied linear model object.
}
\description{
Calculates corrected AIC for an `lm` linear model object.
}
\examples{
#generate data
set.seed(9122023)
data <- data.frame(x = rnorm(100), y = rnorm(100))
AICc(lm(y~x, data = data))

}
