% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitGLMSubsets.R
\name{FitGLMSubsets}
\alias{FitGLMSubsets}
\title{Perform all subsets regression for generalized linear models}
\usage{
FitGLMSubsets(
  response,
  data,
  family,
  intercept = TRUE,
  force_intercept = TRUE,
  cluster = NULL,
  ...
)
}
\arguments{
\item{response}{A character string specifying the name of the response variable.}

\item{data}{A dataframe containing a column corresponding to the response variable in addition to columns for each covariate of interest.}

\item{family}{A family suitable for supplying to the \code{glm} function specifying the error distribution and link function.}

\item{intercept}{A logical indicating whether an intercept term should be considered in models. Defaults to TRUE.}

\item{force_intercept}{A logical indicating whether to force an intercept term into all models if an intercept is desired. Defaults to TRUE.}

\item{cluster}{A cluster created using \code{parallel::makeCluster}.}

\item{...}{Additional arguments that may be supplied when calling \code{glm} to fit the models of interest.}
}
\value{
A list of fitted models suitable for use with the \code{StandICModelSelect} function.
}
\description{
Fit a specified generalized linear model on all subsets of covariates supplied. May be done in parallel if a cluster is supplied. Produces an output suitable for use with the \code{StandICModelSelect} function.
}
\examples{
# example code
# generate some data
data <- data.frame(s = rnorm(200), t = rnorm(200))
data$y <- data$s + rnorm(200)
# perform all subsets regression
model_list <- FitGLMSubsets(response = "y", data = data, family = gaussian(),
  intercept = TRUE, force_intercept = TRUE)
# perform model selection
model_select <- StandICModelSelect(model_list, IC = "AIC")
}
