% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bh.R
\name{ggbsegCoverageFromYear}
\alias{ggbsegCoverageFromYear}
\title{estimate death registration coverage for a single year/sex/region using the modified Bennett-Horiuchi method}
\usage{
ggbsegCoverageFromYear(codi, minA = 15, maxA = 75, minAges = 8,
  exact.ages = NULL, eOpen = NULL, deaths.summed = FALSE)
}
\arguments{
\item{codi}{\code{data.frame} with columns, \code{$pop1}, \code{$pop2}, \code{$deaths}, \code{$date1}, \code{$date2}, \code{$sex}, \code{$age}, and \code{$cod} (to indicate regions, periods, sexes).}

\item{minA}{the minimum of the age range searched. Default 15}

\item{maxA}{the maximum of the age range searched. Default 75}

\item{minAges}{the minimum number of adjacent ages needed as points for fitting. Default 8}

\item{exact.ages}{optional. use an exact set of ages to estimate coverage.}

\item{eOpen}{optional. A user-specified value for remaining life-expectancy in the open age group.}

\item{deaths.summed}{logical. is the deaths column given as the total per age in the intercensal period (\code{TRUE}). By default we assume \code{FALSE}, i.e. that the average annual was given.}
}
\value{
a \code{data.frame} with columns for the coverage coefficient, and the min and max of the age range on which it is based.
}
\description{
Given two censuses and an average annual number of deaths in each age class between censuses, we can use stable population assumptions to estimate the degree of underregistration of deaths. The method estimates age-specific degrees of coverage. The age pattern of these is assumed to be noisy, so we take the arithmetic mean over some range of ages. One may either specify a particular age-range, or let the age range be determined automatically. If the age-range is found automatically, this is done using the method developed for the generalized growth-balance method. Part of this method relies on a prior value for remaining life expectancy in the open age group. By default, this is estimated using a standard reference to the Coale-Demeny West model life table, although the user may also supply a value. The difference between this method and \code{seg()} is that here we adjust census 1 part way through processing, based on some calculations similar to GGB. Called by \code{ggbseg()}. Users probably do not need to use this function directly.
}
\details{
Census dates can be given in a variety of ways: 1) using Date classes, and column names \code{$date1} and \code{$date2} (or an unambiguous character string of the date, like, \code{"1981-05-13"}) or 2) by giving column names \code{"day1","month1","year1","day2","month2","year2"} containing integers. If only \code{year1} and \code{year2} are given, then we assume January 1 dates. If year and month are given, then we assume dates on the first of the month.
}
