summary.DDPstar <-
function(object, ...) {
	res <- list()
	res$call <- object$call
	
	waic <- !is.null(object$WAIC)
	lpml <- !is.null(object$lpml)
	dic  <- !is.null(object$DIC)

	if(waic | lpml | dic) {
		col.names <- c("")
		row.names <- NULL
		m <- matrix(ncol = length(col.names), nrow = ifelse(waic, 2, 0) + ifelse(lpml, 1, 0) + ifelse(dic, 2, 0))
		i <- 1
		if(waic) {
			row.names <- c(row.names, "WAIC", "WAIC (Penalty)")
			m[i,] <-  sprintf("%.3f", object$WAIC$WAIC)
			m[i+1,] <- sprintf("%.3f", object$WAIC$pW)
			i <- i + 2
		}
		if(lpml) {
			row.names <- c(row.names, "LPML")
			m[i,]   <-  sprintf("%.3f", object$lpml$lpml)
			i <- i + 1
		}
		if(dic) {
			row.names <- c(row.names, "DIC", "DIC (Penalty)")
			m[i,] <-  sprintf("%.3f", object$DIC$DIC)
			m[i+1,] <- sprintf("%.3f", object$DIC$pD)
		}
		colnames(m) <- col.names
		rownames(m) <- row.names

		res$bmsc <- m
	}

	print.summary.DDPstar(res, ...)
	invisible(res) 	
}
