% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VolcanoDEGRE.R
\name{VolcanoDEGRE}
\alias{VolcanoDEGRE}
\title{Create a volcano plot to visualize the proportion of downregulated and upregulated genes by applying a log2FC cutoff.}
\usage{
VolcanoDEGRE(
  results,
  log2FC_cutoff = 1,
  padj = 0.05,
  font.x = 10,
  font.y = 10,
  font.tickslab = 10,
  downregulated_color = "coral2",
  upregulated_color = "cornflowerblue",
  xlab = "log2Foldchange",
  ylab = "-log10(P-value)",
  legend_position = "right",
  legend.title = "Regulation"
)
}
\arguments{
\item{results}{a data.frame object. It receives the output of the DEGRE function, filtered or not, as input.}

\item{log2FC_cutoff}{it stores the cutoff of the log2FoldChange. The default is 1.}

\item{padj}{it stores the cutoff of the P-adjusted value (Q-value). The default is 0.05.}

\item{font.x}{the font size of the x axis. The default is 10.}

\item{font.y}{the font size of the y axis. The default is 10.}

\item{font.tickslab}{the font size of the ticks lab. The default is 10.}

\item{downregulated_color}{the colors of the downregulated genes. The default is "coral2".}

\item{upregulated_color}{the colors of the upregulated genes. The default is "cornflowerblue".}

\item{xlab}{the x lab text. The default is "log2Foldchange".}

\item{ylab}{the y lab text. The default is "-log10(P-value)".}

\item{legend_position}{you need to specify here the position of the legend. The default is "right".}

\item{legend.title}{the title of the legend. The default is "Regulation".}
}
\value{
No return value, called for side effects
}
\description{
Create a volcano plot to visualize the proportion of downregulated and upregulated genes by applying a log2FC cutoff.
}
\examples{
dir <- system.file("extdata", package = "DEGRE")
results_DEGRE_example <- read.csv(file.path(dir,"results_DEGRE_example.csv"))
# Running the VolcanoDEGRE function
VolcanoDEGRE(results = results_DEGRE_example,
          log2FC_cutoff = 1,
          padj = 0.05,
          font.x = 10,
          font.y = 10,
          font.tickslab = 10,
          downregulated_color = "coral2",
          upregulated_color = "cornflowerblue",
          xlab = "log2Foldchange",
          ylab = "-log10(P-value)",
          legend_position = "right",
          legend.title = "Regulation")

}
