% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiValues.R
\name{compare_values_on_scale}
\alias{compare_values_on_scale}
\title{compare_values_on_scale}
\usage{
compare_values_on_scale(value1, value2, scale, force_compare = FALSE)
}
\arguments{
\item{value1}{First value.}

\item{value2}{Second value.}

\item{scale}{Normally a \code{DEXiScale} object or a \code{DexiAttribute} object with defined \verb{$scale}.}

\item{force_compare}{\code{logical(1)}. Applies when \code{scale} is \code{NULL} or anything other than expected.
When \code{force_compare = TRUE}, comparison is enforced, assuming \code{"ascending"} scale order.
When \code{force_compare = FALSE}, NA is returned.}
}
\value{
\code{\link[=compare_values]{compare_values()}} result, modified according to \code{scale$order}.
}
\description{
Compare values \code{value1} and \code{value2} considering \code{scale$order}.
Internal DEXi representation is assumed for values, i.e.,
a single number, an integer vector representing a set or \code{\link[=distribution]{distribution()}}.
Distributions are compared as sets.
}
\examples{
compare_values_on_scale(1, 2, NULL)                       # NA
compare_values_on_scale(2, 1, "")                         # NA
compare_values_on_scale(1, 2, NULL, force_compare = TRUE) # -1
compare_values_on_scale(2, 1, "", force_compare = TRUE)   # +1

scl <- DexiDiscreteScale(values = c("a", "b", "c"))
compare_values_on_scale(1, 1, scl)             # 0
compare_values_on_scale(1, 2, scl)             # -1
compare_values_on_scale(3, 2, scl)             # +1
compare_values_on_scale(c(1, 2), c(1, 2), scl) # 0
compare_values_on_scale(c(1, 2), c(2, 3), scl) # NA

scl <- DexiDiscreteScale(order = "descending", values = c("a", "b", "c"))
compare_values_on_scale(1, 1, scl)             # 0
compare_values_on_scale(1, 2, scl)             # +1
compare_values_on_scale(3, 2, scl)             # -1
compare_values_on_scale(c(1, 2), c(1, 2), scl) # 0
compare_values_on_scale(c(1, 2), c(2, 3), scl) # NA

scl <- DexiDiscreteScale(order = "none", values = c("a", "b", "c"))
compare_values_on_scale(1, 1, scl)             # 0
compare_values_on_scale(1, 2, scl)             # NA
compare_values_on_scale(3, 2, scl)             # NA
compare_values_on_scale(c(1, 2), c(1, 2), scl) # 0
compare_values_on_scale(c(1, 2), c(2, 3), scl) # NA
}
\seealso{
\code{\link[=compare_values]{compare_values()}}, \code{\link[=compare_values_by_preference]{compare_values_by_preference()}}
}
