% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiEvaluate.R
\name{evaluation_order}
\alias{evaluation_order}
\title{evaluation_order}
\usage{
evaluation_order(att, prune = list())
}
\arguments{
\item{att}{\link{DexiAttribute}. The starting point of evaluation.}

\item{prune}{A character vector. May contain IDs of aggregate attributes at which the evaluation should
stop, treating them as if they were basic attributes.}
}
\value{
A character vector of attribute IDs.
}
\description{
Determine the evaluation order of attributes. Interpreted as a sequence, the order guarantees
that whenever some attribute is reached as a candidate for evaluation,
all the previous attributes have been already evaluated.
}
\examples{
# Load "Car.dxi"
CarDxi <- system.file("extdata", "Car.dxi", package = "DEXiR")
Car <- read_dexi(CarDxi)

# Full evaluation order, starting with Car$root and without pruning
evaluation_order(Car$root)

# Evaluation order, starting with the TECH.CHAR. attribute
evaluation_order(Car$attrib("TECH.CHAR."))

# evaluation order, starting with Car$root and pruned at "PRICE"
evaluation_order(Car$root, prune = "PRICE")

}
\seealso{
\code{\link[=evaluate]{evaluate()}}
}
