% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IPR.R
\name{IprMh}
\alias{IprMh}
\title{Mantel Haenszel for Item parameter replication}
\usage{
IprMh(
  itemParameterList,
  irtModel = "2pl",
  focalDistribution = "norm",
  focalDistrExtra = list(mean = 0, sd = 1),
  referenceDistribution = "norm",
  referenceDistrExtra = list(mean = 0, sd = 1),
  groupRatio = 1,
  subdivisions = 5000,
  logistic = TRUE
)
}
\arguments{
\item{itemParameterList}{A list where each element is a list containing "focal" and "reference" item Parameters. Item parameters are assumed to be on the same scale. Item parameters for each group should be a matrix with nrow equal to the number of items}

\item{irtModel}{A string stating the irtModel to be used. Should be one of "1pl", "2pl", "3pl", "grm" or "pcm".}

\item{focalDistribution}{A string stating the distribution assumed for the focal group.}

\item{focalDistrExtra}{A list stating the extra parameters needed by the focal distribution function.}

\item{referenceDistribution}{A string stating the distribution assumed for the reference group.}

\item{referenceDistrExtra}{A list stating the extra parameters needed by the reference distribution function.}

\item{groupRatio}{A positive value indicating how many members of the reference group are expected for each member of the focal group.}

\item{subdivisions}{A numeric value indicating the number of subdivisions for numerical integration.}

\item{logistic}{A logical value stating if the IRT model will use the logistic or the normal metric.
Defaults to using the logistic metric by fixing the D constant to 1.
If FALSE the constant is set to 1.702 so that the normal metric is used.}
}
\value{
mh A numeric matrix with the Mantel Haenszel values for all the item parameter in each set of itemParameterList
}
\description{
Calculates the Mantel-Haenszel theoretical parameter under IRT assumptions on a list of item parameters such as those produced by the Ipr function
}
\examples{
# # Not run
# #
# # data(dichotomousItemParameters)
# # threePlParameters <- dichotomousItemParameters
# # isNot3Pl          <- ((dichotomousItemParameters[['focal']][, 3] == 0) |
# #                       (dichotomousItemParameters[['reference']][, 3] == 0))
# #
# # threePlParameters[['focal']]          <- threePlParameters[['focal']][!isNot3Pl, ]
# # threePlParameters[['reference']]      <- threePlParameters[['reference']][!isNot3Pl, ]
# # threePlParameters[['focal']][, 3]     <- threePlParameters[['focal']][, 3] + 0.1
# # threePlParameters[['reference']][, 3] <- threePlParameters[['reference']][, 3] + 0.1
# # threePlParameters[['focal']][, 2]     <- threePlParameters[['focal']][, 2] + 1.5
# # threePlParameters[['reference']][, 2] <- threePlParameters[['reference']][, 2] + 1.5
# # threePlParameters[['focal']]          <- threePlParameters[['focal']][-c(12, 16, 28), ]
# # threePlParameters[['reference']]      <- threePlParameters[['reference']][-c(12, 16, 28), ]
# #
# # threePlAse <- list()
# # threePlAse[["focal"]]     <- AseIrt(itemParameters = threePlParameters[["focal"]],
# #                                     logistic = TRUE,
# #                                     sampleSize = 10000,
# #                                     irtModel = "3pl")
# # threePlAse[["reference"]] <- AseIrt(itemParameters = threePlParameters[["reference"]],
# #                                     logistic = TRUE,
# #                                     sampleSize = 10000,
# #                                     irtModel = "3pl")
# #
# # set.seed(41568)
# # threePlIpr <- Ipr(itemParameters = threePlParameters, itemCovariances = threePlAse,
# #                   nReplicates = 100)
# #
# # threePlMhIpr <- IprMh(itemParameterList = threePlIpr, irtModel = '3pl', logistic = TRUE)

}
\references{
Oshima, T., Raju, N. & Nanda, A. (2006). A new method for assessing the statistical significance in the Differential Functioning of Items and Tests (DFIT) framework. Journal of educational measurement, 43(1), 1--17. doi:10.1111/j.1745-3984.2006.00001.x

Roussos, L., Schnipke, D. & Pashley, P. (1999). A generalized formula for the Mantel-Haenszel Differential Item Functioning parameter. Journal of educational and behavioral statistics, 24(3), 293--322. doi:10.3102/10769986024003293
}
\author{
Victor H. Cervantes <vhcervantesb at unal.edu.co>
}
