% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_hP.R
\name{glm.hP}
\alias{glm.hP}
\title{Fit a hyper-Poisson Double Generalized Linear Model}
\usage{
glm.hP(
  formula.mu,
  formula.gamma,
  init.beta = NULL,
  init.delta = NULL,
  data,
  weights,
  subset,
  na.action,
  maxiter_series = 1000,
  tol = 0,
  offset,
  opts = NULL,
  model.mu = TRUE,
  model.gamma = TRUE,
  x = FALSE,
  y = TRUE,
  z = FALSE
)
}
\arguments{
\item{formula.mu}{an object of class "formula" (or one that can be coerced to
that class): a symbolic description of the model to be fitted.}

\item{formula.gamma}{regression formula linked to \code{log(gamma)}}

\item{init.beta}{initial values for regression coefficients of \code{beta}.}

\item{init.delta}{initial values for regression coefficients of \code{delta}.}

\item{data}{an optional data frame, list or environment (or object that can
be coerced by \code{\link[base]{as.data.frame}} to a data frame) containing
the variables in the model. If not found in data, the variables are taken
from \code{environment(formula)}, typically the environment from which
\code{glm.hP} is called.}

\item{weights}{an optional vector of \sQuote{prior weights} to be used in the
fitting process. Should be \code{NULL} or a numeric vector.}

\item{subset}{an optional vector specifying a subset of observations to be
used in the fitting process.}

\item{na.action}{a function which indicates what should happen when the data
contain \code{NAs}. The default is set by the \code{na.action} setting of
\code{\link[base]{options}}, and is \code{\link[stats]{na.fail}} if that is
unset. The \sQuote{factory-fresh} default is
\code{\link[stats:na.fail]{na.omit}}. Another possible value is
\code{NULL}, no action. Value \code{\link[stats:na.fail]{na.exclude}} can
be useful.}

\item{maxiter_series}{Maximum number of iterations to perform in the
calculation of the normalizing constant.}

\item{tol}{tolerance with default zero meaning to iterate until additional
terms to not change the partial sum in the calculation of the normalizing
constant.}

\item{offset}{this can be used to specify an a priori known component to be
included in the linear predictor during fitting. This should be \code{NULL}
or a numeric vector of length equal to the number of cases. One or more
\code{\link[stats]{offset}} terms can be included in the formula instead or
as well, and if more than one is specified their sum is used. See
\code{\link[stats:model.extract]{model.offset}}.}

\item{opts}{a list with options to the optimizer,
\code{\link[nloptr]{nloptr}}, that fits the model. See, the \code{opts}
parameter of \code{\link[nloptr]{nloptr}} for further details.}

\item{model.mu}{a logical value indicating whether the \emph{mu model frame}
should be included as a component of the returned value.}

\item{model.gamma}{a logical value indicating whether the \emph{gamma model
frame} should be included as a component of the returned value.}

\item{x}{logical value indicating whether the mu model matrix used in the
fitting process should be returned as a component of the returned value.}

\item{y}{logical value indicating whether the response vector used in the
fitting process should be returned as a component of the returned value.}

\item{z}{logical value indicating whether the gamma model matrix used in the
fitting process should be returned as a component of the returned value.}
}
\value{
\code{glm.hP} returns an object of class \code{"glm_hP"}. The
  function \code{\link[base]{summary}} can be used to obtain or print a
  summary of the results.

  The generic accessor functions \code{\link[stats]{coef}},
  \code{\link[stats]{fitted.values}} and \code{\link[stats]{residuals}} can
  be used to extract various useful features of the value returned by
  \code{glm.hP}.

  \code{weights} extracts a vector of weights, one for each case in the fit
  (after subsetting and \code{na.action}).

  An object of class \code{"glm_hP"} is a list containing at least the
  following components:

  \item{\code{coefficients}}{a named vector of coefficients.}
  \item{\code{residuals}}{the residuals, that is response minus fitted
  values.} \item{\code{fitted.values}}{the fitted mean values.}
  \item{\code{linear.predictors}}{the linear fit on link scale.}
  \item{\code{call}}{the matched call.} \item{\code{offset}}{the offset
  vector used.} \item{\code{weights}}{the weights initially supplied, a
  vector of \code{1s} if none were.} \item{\code{df.residual}}{the residual
  degrees of freedom.} \item{\code{df.null}}{the residual degrees of freedom
  for the null model.} \item{\code{y}}{if requested (the default) the y
  vector used.} \item{\code{matrix.mu}}{if requested, the mu model matrix.}
  \item{\code{matrix.gamma}}{if requested, the gamma model matrix.}
  \item{\code{model.mu}}{if requested (the default) the mu model frame.}
  \item{\code{model.gamma}}{if requested (the default) the gamma model
  frame.} \item{\code{nloptr}}{an object of class \code{"nloptr"} with the
  result returned by the optimizer \code{\link[nloptr]{nloptr}}}
}
\description{
The \code{glm.hP} function is used to fit a hyper-Poisson double generalized
linear model with a log-link for the mean (\code{mu}) and the dispersion
parameter (\code{gamma}).
}
\details{
Fit a hyper-Poisson double generalized linear model using as optimizer the
NLOPT_LD_SLSQP algorithm of function \code{\link[nloptr]{nloptr}}.
}
\examples{
## Fit model
Bids$size.sq <- Bids$size ^ 2
fit <- glm.hP(formula.mu = numbids ~ leglrest + rearest + finrest +
              whtknght + bidprem + insthold + size + size.sq + regulatn,
              formula.gamma = numbids ~ 1, data = Bids)

## Summary of the model
summary(fit)

## To see the termination condition of the optimization process
fit$nloptr$message

## To see the number of iterations of the optimization process
fit$nloptr$iterations
}
\references{
Antonio J. Saez-Castillo and Antonio Conde-Sanchez (2013). "A hyper-Poisson
regression model for overdispersed and underdispersed count data",
Computational Statistics & Data Analysis, 61, pp. 148--157.

S. G. Johnson (2018). \href{https://CRAN.R-project.org/package=nloptr}{The
nlopt nonlinear-optimization package}
}
