% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_join.R
\name{multi_join}
\alias{multi_join}
\title{Multi-Dataset Join Utility}
\usage{
multi_join(
  datasets,
  key = c("record_id", "covid_wave", "center"),
  join_type = "left"
)
}
\arguments{
\item{datasets}{A list of data frames to be joined.}

\item{key}{A character string representing the key column to join by. Defaults to "record_id".}

\item{join_type}{A character string specifying the type of join. Options are "left", "right", "inner", or "full".}
}
\value{
A single data frame containing the joined datasets.
}
\description{
This function performs a sequential join of multiple datasets by a specified key column.
}
\examples{
multi_join(
  list(analytics, comorbidities),
  join_type = "left"
)

multi_join(
  list(analytics, comorbidities),
  key = c("record_id", "covid_wave", "center"),
  join_type = "left"
)

}
