% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmcFit.R
\name{dmcFit}
\alias{dmcFit}
\title{dmcFit}
\usage{
dmcFit(
  resOb,
  nTrl = 1e+05,
  startVals = list(),
  minVals = list(),
  maxVals = list(),
  fixedFit = list(),
  freeCombined = list(),
  fitInitialGrid = TRUE,
  fitInitialGridN = 10,
  fixedGrid = list(),
  nCAF = 5,
  nDelta = 19,
  pDelta = vector(),
  tDelta = 1,
  deltaErrors = FALSE,
  spDist = 1,
  drOnset = 0,
  drDist = 0,
  drShape = 3,
  drLim = c(0.1, 0.7),
  rtMax = 5000,
  costFunction = "RMSE",
  printInputArgs = TRUE,
  printResults = FALSE,
  optimControl = list(),
  numCores = 2
)
}
\arguments{
\item{resOb}{Observed data (see flankerData and simonTask for data format) and the function dmcObservedData to create
the required input from either an R data frame or external *.txt/*.csv files}

\item{nTrl}{Number of trials to use within dmcSim.}

\item{startVals}{Starting values for the to-be estimated parameters. This is a list with values specified individually
for amp, tau, drc, bnds, resMean, resSD, aaShape, spShape, spBias, sigm (e.g., startVals = list(amp = 20, tau = 200,
drc = 0.5, bnds = 75, resMean = 300, resSD = 30, aaShape = 2, spShape = 3, spBias = 0, sigm = 4, bndsRate=0, bndsSaturation=0)).}

\item{minVals}{Minimum values for the to-be estimated parameters. This is a list with values specified individually
for amp, tau, drc, bnds, resMean, resSD, aaShape, spShape, spBias, sigm (e.g., minVals = list(amp = 0, tau = 5, drc = 0.1,
bnds = 20, bndsRate=0, bndsSaturation=0, resMean = 200, resSD = 5, aaShape = 1, spShape = 2, spBias = -20, sigm = 1)).}

\item{maxVals}{Maximum values for the to-be estimated parameters. This is a list with values specified individually
for amp, tau, drc, bnds, resMean, resSD, aaShape, spShape, spBias, sigm (e.g., maxVals = list(amp = 40, tau = 300, drc = 1.0,
bnds = 150, bndsRate=1, bndsSaturation=500, resMean = 800, resSD = 100, aaShape = 3, spShape = 4, spBias = 20, sigm = 10))}

\item{fixedFit}{Fix parameter to starting value. This is a list with bool values specified individually for
amp, tau, drc, bnds, resMean, resSD, aaShape, spShape, spBias, sigm (e.g., fixedFit = list(amp = F, tau = F, drc = F,
bnds = F, bndsRate=T, bndsSaturation=T, resMean = F, resSD = F, aaShape = F, spShape = F, spBias = T, sigm = T))
NB. Value if fixed at startVals.}

\item{freeCombined}{If fitting 2+ datasets at once, which parameters are allowed to vary between both
fits (default = all parameters fixed between the two fits e.g. parameter = F).
This is a list with bool values specified individually for
amp, tau, drc, bnds, resMean, resSD, aaShape, spShape, spBias, sigm (e.g., freeCombined = list(amp = F,
tau = F, drc = F, bnds = F, bndsRate=F, bndsSaturation=F, resMean = F, resSD = F, aaShape = F, spShape = F, spBias = F, sigm = F))}

\item{fitInitialGrid}{TRUE/FALSE}

\item{fitInitialGridN}{10 linear steps between parameters min/max values (reduce if searching more than ~2/3 initial parameters)}

\item{fixedGrid}{Fix parameter for initial grid search. This is a list with bool values specified individually for
amp, tau, drc, bnds, resMean, resSD, aaShape, spShape, spBias, sigm (e.g., fixedGrid = list(amp = T, tau = F, drc = T,
bnds = T, bndsRate=T, bndsSaturation=T, resMean = T, resSD = T, aaShape = T, spShape = T, spBias = T, sigm = T)). As a default, the initial gridsearch
only searches the tau space.}

\item{nCAF}{The number of CAF bins.}

\item{nDelta}{The number of delta bins.}

\item{pDelta}{An alternative option to nDelta (tDelta = 1 only) by directly specifying required percentile values (vector of values 0-100)}

\item{tDelta}{The type of delta calculation (1=direct percentiles points, 2=percentile bounds (tile) averaging)}

\item{deltaErrors}{TRUE/FALSE Calculate delta bins for error trials}

\item{spDist}{The starting point (sp) distribution (0 = constant, 1 = beta, 2 = uniform)}

\item{drOnset}{The starting point of controlled drift rate (i.e., "target" information) relative to automatic ("distractor" incormation) (> 0 ms)}

\item{drDist}{The drift rate (dr) distribution type (0 = constant, 1 = beta, 2 = uniform)}

\item{drShape}{The drift rate (dr) shape parameter}

\item{drLim}{The drift rate (dr) range}

\item{rtMax}{The limit on simulated RT (decision + non-decisional components)}

\item{costFunction}{The cost function to minimise: root mean square error ("RMSE": default),
squared percentage error ("SPE"), or likelihood-ratio chi-square statistic ("GS")}

\item{printInputArgs}{TRUE (default) /FALSE}

\item{printResults}{TRUE/FALSE (default)}

\item{optimControl}{Additional control parameters passed to optim (see optim details section)}

\item{numCores}{Number of cores to use}
}
\value{
dmcfit returns an object of class "dmcfit" with the following components:

\item{sim}{Individual trial data points (RTs for all trial types e.g., correct/error trials) and activation vectors from the simulation}
\item{summary}{Condition means for reaction time and error rate}
\item{caf}{Conditional Accuracy Function (CAF) data per bin}
\item{delta}{DataFrame with distributional delta analysis data correct trials (Bin, meanComp, meanIncomp, meanBin, meanEffect)}
\item{delta_errs}{DataFrame with distributional delta analysis data incorrect trials (Bin, meanComp, meanIncomp, meanBin, meanEffect)}
\item{par}{The fitted model parameters + final cost value of the fit}
}
\description{
Fit theoretical data generated from dmcSim to observed data by
minimizing the root-mean-square error ("RMSE") between a weighted combination
of the CAF and CDF functions using optim (Nelder-Mead). Alternative cost functions
include squared percentage error ("SPE"), and g-squared statistic ("GS").
}
\examples{
\donttest{
# Code below can exceed CRAN check time limit, hence donttest
# Example 1: Flanker data from Ulrich et al. (2015)
fit <- dmcFit(flankerData) # only initial search tau
plot(fit, flankerData)
summary(fit)

# Example 2: Simon data from Ulrich et al. (2015)
fit <- dmcFit(simonData) # only initial search tau
plot(fit, simonData)
summary(fit)

# Example 3: Flanker data from Ulrich et al. (2015) with non-default
# start vals and some fixed values
fit <- dmcFit(flankerData,
  startVals = list(drc = 0.6, aaShape = 2.5),
  fixedFit = list(drc = TRUE, aaShape = TRUE)
)

# Example 4: Simulated Data (+ve going delta function)
dat <- createDF(nSubjects = 20, nTrl = 500, design = list("Comp" = c("comp", "incomp")))
dat <- addDataDF(dat,
  RT = list(
    "Comp_comp" = c(510, 100, 100),
    "Comp_incomp" = c(540, 130, 85)
  ),
  Error = list(
    "Comp_comp" = c(4, 3, 2, 1, 1),
    "Comp_incomp" = c(20, 4, 3, 1, 1)
  )
)
datOb <- dmcObservedData(dat, columns = c("Subject", "Comp", "RT", "Error"))
plot(datOb)
fit <- dmcFit(datOb, nTrl = 5000)
plot(fit, datOb)
summary(fit)

# Example 5: Fitting 2+ datasets within all common parameters values
fit <- dmcFit(list(flankerData, simonData), nTrl=1000)
plot(fit[[1]], flankerData)
plot(fit[[2]], simonData)
summary(fit)

# Example 6: Fitting 2+ datasets within some parameters values varying
fit <- dmcFit(list(flankerData, simonData), freeCombined=list(amp=TRUE, tau=TRUE), nTrl=1000)
summary(fit) # NB. amp/tau values different, other parameter values equal
}


}
