% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapGenotypes.R
\name{map.genotypes}
\alias{map.genotypes}
\title{Maximum posterior genotypes of unknown contributors}
\usage{
map.genotypes(
  mixture,
  pmin,
  U = seq_along(mixture$U),
  markers = mixture$markers,
  type = c("seen", "all", "unseen")
)
}
\arguments{
\item{mixture}{a DNA mixture}

\item{pmin}{A list of the minimum probability to consider for each marker.}

\item{U}{Optionally the indices of the unknown contributors of interest, specified as an integer vector.}

\item{markers}{Optionally, a subset of markers.}

\item{type}{It may be of interest to consider only the prediction of alleles in some subset of alleles. We allow
\describe{
\item{\code{"seen"}}{Consider only alleles that are seen in at least one EPG}
\item{\code{"all"}}{Consider the entire allelic range}
\item{\code{"unseen"}}{Consider only alleles that are not seen in any EPG (possibly redundant)}
}}
}
\value{
A list, which for each marker contains the maximum
posterior configurations of allele counts (genotypes) above the specified probabilities \code{pmin}.
}
\description{
For each marker, a ranked list of configurations of genotypes for some
or all unknown contributors is returned. The list contains all
configurations with posterior probability higher than some
specified \code{pmin}.

\emph{IMPORTANT: This is the \pkg{DNAmixturesLite} package, which
is intended as a service to enable users to try \pkg{DNAmixtures}
without purchasing a commercial licence for Hugin. When at all
possible, we strongly recommend the use of \pkg{DNAmixtures}
rather than this lite-version. See
\url{https://dnamixtures.r-forge.r-project.org/} for details on
both packages.}

\emph{While the lite-version seeks to provide the full functionality of
\pkg{DNAmixtures}, note that computations are much less efficient
and that there are some differences in available functionality. Be
aware that the present documentation is copied from
\pkg{DNAmixtures} and thus may not accurately describe the
implementation of this lite-version.}
}
\details{
Note that an error occurs if there are no configurations
with probability higher than \code{pmin}. In this case, try a
smaller \code{pmin}.

The function makes use of
\code{\link[gRaven]{map.configurations}}, which localises the
configurations of highest high posterior probability by simulating
from the Bayesian networks until enough (at least mass
1-\code{pmin}) of the state space has been explored -- the
computation time is thus dependent on how flat the posterior is,
and how small \code{pmin} is. The simulation is used only to locate
the relevant configurations; the computed probabilities are exact.
}
\examples{
data(MC18, USCaucasian, SGMplusDyes)
mix <- DNAmixture(list(MC18), k = 3, K = "K1", C = list(50), database = USCaucasian)
p <- mixpar(rho = list(30), eta = list(30), xi = list(0.07),
            phi = list(c(K1 = 0.7, U1 =0.2, U2 = 0.1)))
## Inlude the peak height information
setPeakInfo(mix, p)
## Marginally best genotypes for contributor U1
mpU1 <- map.genotypes(mix, pmin = 0.01, U = 1, type = "seen", markers = "D16S539")
summary(mpU1)
\donttest{
## Jointly best genotypes for all unknown contributors
mp <- map.genotypes(mix, pmin = 0.01, type = "seen")
summary(mp) ## Profiles as genotypes rather than allelecounts
}
}
\seealso{
\code{\link{summary.map.genotypes}}
}
