% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot.DNAmixture}
\alias{plot.DNAmixture}
\title{Plot a DNA mixture model}
\usage{
\method{plot}{DNAmixture}(
  x,
  traces = seq_len(x$ntraces),
  markers = x$markers,
  epg = FALSE,
  dyecol = lapply(dyes(x), names),
  pw = 0.4,
  threshold = TRUE,
  panel = NULL,
  add = FALSE,
  ask = NULL,
  ...
)
}
\arguments{
\item{x}{A \code{DNAmixture}.}

\item{traces}{Indices giving the mixtures, for which plots should be made.}

\item{markers}{Vector of names giving the markers, for which plots should be made.}

\item{epg}{Should a stylized EPG be produced? This requires a list
of dyes to be specified for the mixtures, possibly through
\code{\link{dyes}}.}

\item{dyecol}{List containing for each mixture a vector of dye
names. The default is to use the names in \code{dyes(x)}. Set to
\code{NULL} to ignore.}

\item{pw}{Peaks are \code{2*pw} wide.}

\item{threshold}{Should the detection thresholds be indicated on the plot?}

\item{panel}{Alternative function for drawing the peaks. For
instance \code{lines} can be used for making triangular peaks. This functionality will be removed.}

\item{add}{Add to existing plot? (not meaningful if \code{EPG = TRUE}.)}

\item{ask}{Should the user be prompted for page changes? The
default is \code{TRUE}, when the device is
\code{dev.interactive()} and there is a need for multiple pages.}

\item{...}{Other parameters to be passed on to \code{plot}}
}
\value{
A \code{data.frame} containing the plotted data points.
}
\description{
Plot of peak heights against repeat numbers for each marker.

\emph{IMPORTANT: This is the \pkg{DNAmixturesLite} package, which
is intended as a service to enable users to try \pkg{DNAmixtures}
without purchasing a commercial licence for Hugin. When at all
possible, we strongly recommend the use of \pkg{DNAmixtures}
rather than this lite-version. See
\url{https://dnamixtures.r-forge.r-project.org/} for details on
both packages.}

\emph{While the lite-version seeks to provide the full functionality of
\pkg{DNAmixtures}, note that computations are much less efficient
and that there are some differences in available functionality. Be
aware that the present documentation is copied from
\pkg{DNAmixtures} and thus may not accurately describe the
implementation of this lite-version.}
}
\examples{
data(MC15, MC18, USCaucasian, SGMplusDyes)
mix <- DNAmixture(list(MC15, MC18), C = list(50,50), k = 3, K = c("K1", "K3"),
                  database = USCaucasian)
## Plot as a stylized EPG, using "orange" for the "yellow" dye
names(SGMplusDyes) <- c("blue", "green", "orange")
dyes(mix) <- list(SGMplusDyes, SGMplusDyes)
plot(mix, epg = TRUE)
## We can also supress the dye colors
plot(mix, traces = 1, epg = TRUE, dyecol = NULL)
## Create a user specified layout
op <- par(mfrow = c(2,3))
plot(mix, markers = c("VWA", "D19S433", "TH01"), col = "red")
par(mfrow = op)
plot(mix, traces = 1, markers = "D19S433", col = "orange",
     main = "A single marker", cex.main = 2, ylim = c(0,200))
}
