% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setCPT.R
\name{setCPT}
\alias{setCPT}
\title{Set conditional probability tables for all auxiliary variables}
\usage{
setCPT(mixture, pars, markers = mixture$markers)
}
\arguments{
\item{mixture}{A DNA mixture}

\item{pars}{A list of parameters}

\item{markers}{Optionally, a list of markers for which to set the tables}
}
\value{
List containing evidence for conditioning on peak heights.
}
\description{
A wrapper-function for the case where the conditional probability
tables are to be set in a DNA mixture model for all the auxiliary variables
(O, D and Q, at all markers and all alleles).

\emph{IMPORTANT: This is the \pkg{DNAmixturesLite} package, which is intended as a service to enable users to try \pkg{DNAmixtures} without purchasing a commercial licence for Hugin. When at all possible, we strongly recommend the use of \pkg{DNAmixtures} rather than this lite-version. See \url{https://dnamixtures.r-forge.r-project.org/} for details on both packages.}

\emph{While the lite-version seeks to provide the full functionality of \pkg{DNAmixtures}, note that computations are much less efficient and that there are some differences in available functionality. Be aware that the present documentation is copied from \pkg{DNAmixtures} and thus may not accurately describe the implementation of this lite-version.}
}
\details{
The conditional probability tables are set according to a list of
specified parameters and the observed peak heights. The function
returns evidence for future use on the nodes O.
}
\seealso{
For further details, see in particular \code{\link{setCPT.O}}.
}
