% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drdrtest.R
\name{drdrtest}
\alias{drdrtest}
\title{The function for performing tests of average treatment effects with user specified nuisance functions}
\usage{
drdrtest(
  y,
  a,
  l,
  arange,
  pifunc,
  mufunc,
  h = NULL,
  b = 1000,
  dist = "TwoPoint",
  pi.low = 0.01,
  a.grid.size = 401
)
}
\arguments{
\item{y}{A vector containing the outcomes for each observation}

\item{a}{A vector containing the treatment levels (dosage) for each observation}

\item{l}{A data.frame containing the observations of covariates}

\item{arange}{A vector of length 2 giving the lower bound and upper bound of  treatment levels}

\item{pifunc}{A user specifid function or wapper that takes treatment a as the first argument and
covariates l as the second argument and return propensit scores}

\item{mufunc}{A user specifid function or wapper that takes treatment a as the first argument and
covariates l as the second argument and return outcome regression values}

\item{h}{bandwidth to be used in kernel regression. If not specified, will by default use "rule of thumb" bandwidth selector}

\item{b}{number of Bootstrap samples to be generated}

\item{dist}{distibution used to generate residuals for Bootstrap samples. Currently only have two options, "TwoPoint" and "Rademachar"}

\item{pi.low}{Lower bound to truncate propensity scores}

\item{a.grid.size}{size of equally spaced grid points over \code{arange} to be generate for numerically evaluating the integral in test statistic}
}
\value{
A list containing \describe{
\item{p.value:}{P value of the test result}
\item{test.stat:}{Value of the observed test statistic}
\item{Bootstrap.samples:}{A vector containing test statistic values from Bootstrap samples}
\item{loc.fit:}{A list containg evalution points of average treatment effect and the corresponding values}
\item{bandwidth:}{Bandwidth used in kernel regression}
}
}
\description{
This is the function for testing average treatment effects with user specified nuisance functions.
}
\examples{
mu.mod<-function(a,l,delta,height){
    mu <- as.numeric(l\%*\%c(0.2,0.2,0.3,-0.1))+triangle(a-2.5,delta,height)+a*(-0.1*l[,1]+0.1*l[,3])
    return(mu)
}
triangle <- function(a,delta,height){
    y <- exp(-a^2/((delta/2)^2))*height
    return(y)
}
set.seed(2000)
n <- 500
d <- 4
sigma <- 0.05
delta <- 1
height <- 0
arange<-c(0.01,4.99)

l <- matrix(rnorm(n*d),ncol=d)
colnames(l) <- paste("l",1:4,sep="")
logit.lambda <- as.numeric(l\%*\%c(0.1,0.1,-0.1,0.2))
lambda <- exp(logit.lambda)/(1+exp(logit.lambda))
a <- rbeta(n, shape1 = lambda, shape2 =1-lambda)*5

mu <- mu.mod(a,l,delta,height)
residual.list <- rnorm(n,mean=0,sd=sigma)
y <- mu+residual.list

## We use the oracal propensity score and outcome regression for illustration
pifunc <- function(a,l){
   l <- as.matrix(l)
   logit.lambda <- as.numeric(l\%*\%c(0.1,0.1,-0.1,0.2))
   lambda <- exp(logit.lambda)/(1+exp(logit.lambda))
   return(dbeta(a/5,shape1=lambda,shape2 = 1-lambda)/5)
}

mufunc <- function(a,l){
   l <- as.matrix(l)    
   return(mu.mod(a,l,delta,height))
}
out <- drdrtest(y,a,data.frame(l),arange,pifunc,mufunc)
}
