% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_gdm.R
\name{simulate_genetic_distances}
\alias{simulate_genetic_distances}
\title{Simulate genetic distances using realistic population structure}
\usage{
simulate_genetic_distances(
  n_pops = 50,
  n_major_groups = 5,
  n_subgroups = 12,
  geo_dims = 2,
  genetic_dims = 2,
  group_separation = 15,
  subgroup_separation = 5,
  pop_dispersion = 0.5,
  isolation_factor = 0.8,
  admixture_prob = 0.1,
  bottleneck_prob = 0.05,
  noise_level = 0.1,
  nonlinear_factor = 0.7,
  use_subgroups = TRUE,
  use_genetic_dims = TRUE,
  use_admixture = TRUE,
  use_bottlenecks = TRUE,
  use_isolation_by_distance = TRUE,
  use_nonlinear = TRUE,
  use_noise = TRUE,
  seed = NULL,
  verbose = TRUE
)
}
\arguments{
\item{n_pops}{Number of populations}

\item{n_major_groups}{Number of major groups}

\item{n_subgroups}{Number of subgroups}

\item{geo_dims}{Geographic dimensions}

\item{genetic_dims}{Additional genetic drift dimensions}

\item{group_separation}{Separation between major groups}

\item{subgroup_separation}{Separation between subgroups}

\item{pop_dispersion}{Within-subgroup dispersion}

\item{isolation_factor}{Weight for geography in isolation-by-distance model (0-1)}

\item{admixture_prob}{Proportion of admixed populations}

\item{bottleneck_prob}{Proportion of bottlenecked populations}

\item{noise_level}{Noise level in transformation}

\item{nonlinear_factor}{Nonlinearity factor in transformation}

\item{use_subgroups}{Whether to create subgroups}

\item{use_genetic_dims}{Whether to include genetic dimensions}

\item{use_admixture}{Whether to include admixture}

\item{use_bottlenecks}{Whether to include bottlenecks}

\item{use_isolation_by_distance}{Whether to weight geographic distance}

\item{use_nonlinear}{Whether to apply nonlinear transformation}

\item{use_noise}{Whether to add noise}

\item{seed}{Optional seed for reproducibility (NULL leaves the RNG state unchanged)}

\item{verbose}{Print diagnostics}
}
\value{
A list with \code{distance_matrix}, \code{population_info}, \code{position_matrix}, and \code{parameters}.
}
\description{
Generates a synthetic genetic distance matrix and metadata using hierarchical population structure, admixture and bottleneck options.
}
