% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiDelta.R
\name{multiDelta}
\alias{multiDelta}
\title{Performe massive Delta analysis}
\usage{
multiDelta(
  data,
  which.measure = c("Delta", "Agreement", "Conformity", "Predictivity", "Consistency"),
  tol = 1e-07,
  mxits = 100
)
}
\arguments{
\item{data}{a data.frame whose first column is the goldstandard.}

\item{which.measure}{character string indicating the measure of interest to retrieve from the analysis. Valid options are:
\code{"Delta"} (returns global Delta and SE), \code{"Agreement"} (returns measure of agreement of each category and SE),
\code{"Conformity"} (returns measure of conformity of each category and SE),
\code{"Predictivity"} (returns measure of predictivity of each category and SE),
and \code{"Consistency"} (returns measure of consistency of each category and SE).}

\item{tol}{the desired tolerance applied to find the root of the unknown constant B, needed to estimate the model parameters.}

\item{mxits}{the maximum numer of iterations applied to find the root of the unknown constant B, needed to estimate the model parameters.}
}
\value{
An object of class \code{"multiDelta"}, which is a list of as many elements as measures selected.
}
\description{
\code{multiDelta()} performs the analysis of Delta for multiple raters against a goldstandard.
}
\details{
A print method is available for \code{"multiDelta"} objects.
The results can be reported as plain tex (tex = F) or LaTeX formatted (tex = T).
In the latter case, the table can be transposed (transpose = T).
}
\examples{
# Create a data.frame for 1 goldstandards and 9 raters
dat = data.frame(replicate(10, sample(1:3, 120, replace = TRUE)))

# Compute de Delta model and return the Consistency a Conformity measures
mDelta = multiDelta(dat, which.measure = c('Consistency', 'Conformity'))
print(mDelta, tex = TRUE, transpose = TRUE)
}
