% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DepLogoR.R
\name{filter.by.conservation}
\alias{filter.by.conservation}
\title{Filters columns (sequence positions) by conservation}
\usage{
filter.by.conservation(relative.ic)
}
\arguments{
\item{relative.ic}{the maximum relative information content allowed
to retain a position}
}
\value{
function that, given a \link{DLData} object, returns \code{TRUE} 
  for every column that does not exceed the specified relative information content
}
\description{
Filters columns based on the relative information content of each column
which is the standard information content normalized to the interval [0,1],
where 0 corresponds to uniform distribution and 1 to perfect conservation
of one nucleotide or amino acid, respectively.
}
\examples{
fun <- filter.by.conservation(relative.ic = 0.9)
}
\author{
Jan Grau <grau@informatik.uni-halle.de>
}
