% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/V_a.R
\name{V_a}
\alias{V_a}
\title{Reserve Valuation for Life Annuities}
\usage{
V_a(
  px,
  x,
  h,
  n,
  k = 1,
  cantprem = 1,
  premperyear = 1,
  i = 0.04,
  data,
  prop = 1,
  assumption = "none",
  cap,
  t
)
}
\arguments{
\item{px}{A numeric value. The value of the premium paid in each period.}

\item{x}{An integer. The age of the insuree.}

\item{h}{An integer. The deferral period.}

\item{n}{An integer. Number of years of coverage.}

\item{k}{An integer. Number of payments per year.}

\item{cantprem}{An integer. The total number of premiums.}

\item{premperyear}{An integer. The number of premiums to be paid per year.}

\item{i}{The interest rate. A numeric type value.}

\item{data}{A data.frame containing the mortality table, with the first column being the age and the second one, the probability of death.}

\item{prop}{A numeric value. It represents the proportion of the mortality table used (between 0 and 1).}

\item{assumption}{A character string. The assumption used for fractional ages ("UDD" for uniform distribution of deaths, "constant" for constant force of mortality and "none" if there is no fractional coverage).}

\item{cap}{A numeric type value. The annualized value of the payment.}

\item{t}{An integer. The moment of valuation (in months if it is a fractional coverage or in years if it is not).}
}
\value{
A data frame with Premium, Risk, 1/E and reserve values up to the moment t.
}
\description{
Calculates the reserve for the life Annuity up to the moment 't'.
}
\examples{
V_a(147.814202915034,20,5,10,1,5,1,0.04,CSO80MANB,1,"none",100,15)
V_a(148.324902023591/12,20,5,10,4,60,12,0.04,CSO80MANB,1,"constant",100,178)
V_a(223633.861110949,25,0,25,12,10,1,0.04,CSO80MANB,1,"UDD",120000,300)

}
\references{
Chapter 5 of  Life Contingencies (1952) by Jordan, Chapter 11 of  Actuarial Mathematics for Life Contingent Risks (2009) by Dickson, Hardy and Waters.
}
\keyword{Annuities}
\keyword{Life}
\keyword{Reserve}
