% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SplitData.R
\name{SplitData}
\alias{SplitData}
\title{Partition a dataset into independent subsets}
\usage{
SplitData(data, n.sets = c(3, 2), split.proportions = NULL)
}
\arguments{
\item{data}{A data frame representing the *development*  dataset used for building a treatment rule}

\item{n.sets}{A numeric/integer equal to either 3 (if a development/validation/evaluation partition is desired) or 2 (if there is no model-selection and only a development/evaluation partition is desired).}

\item{split.proportions}{A numeric vector with length equal to \code{n.sets}, providing the proportion of observations in \code{data} that should be assigned to the development/evaluation partitions (if \code{n.sets=2}) or to the development/validation/evaluation partitions (if \code{n.sets=3}). The entries must sum to 1.}
}
\value{
A data.frame equal to \code{data} with an additional column named `partition', which is a factor variable with levels equal to `development' and `evaluation' (if \code{n.sets=2})  or to  `development', `validation', and `evaluation' (if \code{n.sets=3}).
}
\description{
To get a trustworthy estimate of how a developed treatment rule will perform in independent samples drawn from the same population, it is critical that rule development be performed independently of rule evaluation. Further, it is common to perform model selection to settle on the form of the developed treatment rule and, in this case, it is essential that the ultimately chosen treatment rule is also evaluated on data that did not inform any stage of the model-building. The \code{SplitData()} function partitions a dataset so rule development/validation/evaluation (or development/evaluation if there is no model selection) can quickly be performed on independent datasets. This function is only appropriate for the simple setting where the rows in a given dataset are independent of one another (e.g. the same individuals are not represented with multiple rows).
}
\examples{
set.seed(123)
example.split <- SplitData(data=obsStudyGeneExpressions,
                                     n.sets=3, split.proportions=c(0.5, 0.25, 0.25))
table(example.split$partition)
}
