% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DF_pred.R
\name{DF_pred}
\alias{DF_pred}
\title{Decision Forest algorithm: Model prediction}
\usage{
DF_pred(DT_models, X, Y = NULL)
}
\arguments{
\item{DT_models}{Constructed DF models}

\item{X}{Test Dataset}

\item{Y}{Test data endpoint}
}
\value{
.$accuracy:      Overall test accuracy

.$predictions:    Detailed test prediction
}
\description{
Decision Forest algorithm: Model prediction with constructed DF models.
  DT_models is a list of Decision Tree models (rpart.objects) generated by DF_train()
  DT_train_CV() is only designed for Cross-validation and won't generate models
}
\examples{
  # data(demo_simple)
  X = data_dili$X
  Y = data_dili$Y
  names(Y)=rownames(X)

  random_seq=sample(nrow(X))
  split_rate=3
  split_sample = suppressWarnings(split(random_seq,1:split_rate))
  Train_X = X[-random_seq[split_sample[[1]]],]
  Train_Y = Y[-random_seq[split_sample[[1]]]]
  Test_X = X[random_seq[split_sample[[1]]],]
  Test_Y = Y[random_seq[split_sample[[1]]]]

  used_model = DF_train(Train_X, Train_Y)
  Pred_result = DF_pred(used_model,Test_X,Test_Y)



}
