% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiSSMod.R
\docType{data}
\name{CreditMDR}
\alias{CreditMDR}
\title{Credit cards derogatory reports data}
\format{A data frame with 13444 observations of 8 variables as below;
\describe{
 \item{MAJORDRG}{count of major derogatory reports (numeric)}
 \item{CARDHLDR}{1 for cardholders, 0 for denied applicants (categorical)}
 \item{AGE}{age in years and twelfths of a year (numeric)}
 \item{INCOME}{primary income, divided by 10,000 (numeric)}
 \item{OWNRENT}{ownRent, individual owns (1) or rents (0) home (categorical)}
 \item{ADEPCNT}{not classified yet (numeric)}
 \item{SELFEMPL}{self employed; 1=yes, 0=no (categorical)}
 \item{EXP_INC}{average expenditure for 12 months/average monthly income (numeric)}
}}
\source{
Greene, W. H. (1992) \emph{A Statistical Model for Credit
Scoring}. Working Paper No. EC-92-29, Department of Economics, Stern School
of Business, New York University, 1992.

\url{http://pages.stern.nyu.edu/~wgreene/Text/Edition7/tablelist8new.htm}
}
\usage{
data(CreditMDR)
}
\description{
Data is originally from Greene (1992), used for studying statistical credit scoring methods.
}
\references{
Greene, W. H. (2012) \emph{Econometric Analysis, 7th Edition}. Pearson
education.

Azzalini, A., Kim, H.-M. and Kim, H.-J. (2019) Sample selection
models for discrete and other non-Gaussian response variables.
 \emph{Statistical Methods & Applications}, \strong{28}, 27--56. First online 30 March 2018.
\url{https://doi.org/10.1007/s10260-018-0427-1}
}
\keyword{datasets}
