% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{ugi_bleeding_df}
\alias{ugi_bleeding_df}
\title{H2 Antagonists in UGIB}
\format{
A data frame with 27 observations and 14 variables:
\describe{
  \item{id}{Integer study identifier}
  \item{trial}{Character trial name/location}
  \item{year}{Integer publication year}
  \item{ref}{Integer reference number}
  \item{trt}{Character treatment description}
  \item{ctrl}{Character control description}
  \item{nti}{Integer treatment group sample size}
  \item{b.xti}{Integer treatment group bleeding events}
  \item{o.xti}{Integer treatment group other events}
  \item{d.xti}{Integer treatment group deaths}
  \item{nci}{Integer control group sample size}
  \item{b.xci}{Integer control group bleeding events}
  \item{o.xci}{Integer control group other events}
  \item{d.xci}{Integer control group deaths}
}
}
\source{
Data taken from the \pkg{metadat} package version 1.4-0.
}
\usage{
data(ugi_bleeding_df)
}
\description{
This dataset, ugi_bleeding_df, is a data frame containing results from
27 studies examining the effectiveness of histamine H2 antagonists (cimetidine or ranitidine)
in treating acute upper gastrointestinal hemorrhage, with 14 variables per study.
}
\details{
The dataset name has been kept as 'ugi_bleeding_df' to avoid confusion with other
datasets in the R ecosystem. This naming convention helps distinguish this dataset as part of the
DigestiveDataSets package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been
modified in any way.
}
