% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_funs.R
\name{summary.DiscreteFDR}
\alias{summary.DiscreteFDR}
\alias{print.summary.DiscreteFDR}
\title{Summarizing Discrete FDR Results}
\usage{
\method{summary}{DiscreteFDR}(object, ...)

\method{print}{summary.DiscreteFDR}(x, max = NULL, ...)
}
\arguments{
\item{object}{an object of class \code{DiscreteFDR}.}

\item{...}{further arguments passed to or from other methods.}

\item{x}{an object of class \code{summary.DiscreteFDR}.}

\item{max}{numeric or \code{NULL}, specifying the maximal number of
\emph{rows} of the p-value table to be printed. By default,
when \code{NULL}, \code{getOption("max.print")} is used.}
}
\value{
\code{summary.DiscreteFDR} computes and returns a list that includes all the
data of an input \code{DiscreteFDR} object, plus
\item{Table}{\code{data.frame}, sorted by the raw p-values, that contains the
indices, the raw p-values themselves, their respective critical
values (if present), their adjusted p-values (if present) and a
logical column to indicate rejection.}
}
\description{
\code{summary} method for class \code{DiscreteFDR}.
}
\details{
\code{summary.DiscreteFDR} objects contain all data of an \code{DiscreteFDR} object,
but also include an additional table which includes the raw p-values,
their indices, the respective critical values (if present), the adjusted
p-values (if present) and a logical column to indicate rejection. The table
is sorted in ascending order by the raw p-values.

\code{print.summary.DiscreteFDR} simply prints the same output as
\code{print.DiscreteFDR}, but also prints the p-value table.
}
\examples{
X1 <- c(4, 2, 2, 14, 6, 9, 4, 0, 1)
X2 <- c(0, 0, 1, 3, 2, 1, 2, 2, 2)
N1 <- rep(148, 9)
N2 <- rep(132, 9)
Y1 <- N1 - X1
Y2 <- N2 - X2
df <- data.frame(X1, Y1, X2, Y2)
df

# Compute p-values and their supports of Fisher's exact test
test.result <- generate.pvalues(df, "fisher")
raw.pvalues <- test.result$get_pvalues()
pCDFlist <- test.result$get_pvalue_supports()

DBH.sd.crit <- DBH(raw.pvalues, pCDFlist, direction = "sd",
                   ret.crit.consts = TRUE)
summary(DBH.sd.crit)

}
