% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics-base.R, R/class-CloudConfig.R,
%   R/method-DockerCluster.R, R/method-DockerContainer.R
\name{getDockerStaticData}
\alias{getDockerStaticData}
\alias{setDockerStaticData}
\alias{getDockerStaticData,CloudConfig-method}
\alias{setDockerStaticData,CloudConfig-method}
\alias{getDockerStaticData,DockerCluster-method}
\alias{setDockerStaticData,DockerCluster-method}
\alias{getDockerStaticData,DockerContainer-method}
\alias{setDockerStaticData,DockerContainer-method}
\title{get/set docker cluster static data}
\usage{
getDockerStaticData(x)

setDockerStaticData(x, staticData)

\S4method{getDockerStaticData}{CloudConfig}(x)

\S4method{setDockerStaticData}{CloudConfig}(x, staticData)

\S4method{getDockerStaticData}{DockerCluster}(x)

\S4method{setDockerStaticData}{DockerCluster}(x, staticData)

\S4method{getDockerStaticData}{DockerContainer}(x)

\S4method{setDockerStaticData}{DockerContainer}(x, staticData)
}
\arguments{
\item{x}{The object which the static data will be extracted from
or the object that will hold the unserialized data.}

\item{staticData}{The data returned by \code{getDockerStaticData}}
}
\value{
getDockerStaticData: Any data that is serializable
setDockerStaticData: No return value should be expected, the object that
is passed to the function will be updated.
}
\description{
get/set docker cluster static data.
These functions are designed for the \code{reconnect} function for \code{DockerCluster}.
The return value can be serialized and used by the cloud provider to recover
the \code{DockerCluster} object. The default method for \code{DockerCluster} will
use \code{getDockerStaticData} to get the static data in \code{cloudConfig}, \code{ServerContainer}
and \code{WorkerContainer}.
}
\section{Functions}{
\itemize{
\item \code{getDockerStaticData,CloudConfig-method}: The method for CloudConfig

\item \code{setDockerStaticData,CloudConfig-method}: The method for CloudConfig

\item \code{getDockerStaticData,DockerCluster-method}: The method for DockerCluster

\item \code{setDockerStaticData,DockerCluster-method}: The method for DockerCluster

\item \code{getDockerStaticData,DockerContainer-method}: The method for DockerContainer

\item \code{setDockerStaticData,DockerContainer-method}: The method for DockerContainer
}}

