% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/double_ml_irm.R
\name{DoubleMLIRM}
\alias{DoubleMLIRM}
\title{Double machine learning for interactive regression models}
\format{
\link[R6:R6Class]{R6::R6Class} object inheriting from \link{DoubleML}.
}
\description{
Double machine learning for interactive regression models.
}
\details{
Interactive regression (IRM) models take the form

\eqn{Y = g_0(D,X) + U},

\eqn{D = m_0(X) + V},

with \eqn{E[U|X,D]=0} and \eqn{E[V|X] = 0}. \eqn{Y} is the outcome variable
and \eqn{D \in \{0,1\}} is the binary treatment variable. We consider
estimation of the average treamtent effects when treatment effects are
fully heterogeneous. Target parameters of interest in this model are the
average treatment effect (ATE),

\eqn{\theta_0 = E[g_0(1,X) - g_0(0,X)]}

and the average treament effect on the treated (ATTE),

\eqn{\theta_0 = E[g_0(1,X) - g_0(0,X)|D=1]}.
}
\examples{
\donttest{
library(DoubleML)
library(mlr3)
library(mlr3learners)
library(data.table)
set.seed(2)
ml_g = lrn("regr.ranger",
  num.trees = 100, mtry = 20,
  min.node.size = 2, max.depth = 5)
ml_m = lrn("classif.ranger",
  num.trees = 100, mtry = 20,
  min.node.size = 2, max.depth = 5)
obj_dml_data = make_irm_data(theta = 0.5)
dml_irm_obj = DoubleMLIRM$new(obj_dml_data, ml_g, ml_m)
dml_irm_obj$fit()
dml_irm_obj$summary()
}
\dontrun{
library(DoubleML)
library(mlr3)
library(mlr3learners)
library(mlr3tuning)
library(data.table)
set.seed(2)
ml_g = lrn("regr.rpart")
ml_m = lrn("classif.rpart")
obj_dml_data = make_irm_data(theta = 0.5)
dml_irm_obj = DoubleMLIRM$new(obj_dml_data, ml_g, ml_m)

param_grid = list(
  "ml_g" = paradox::ps(
    cp = paradox::p_dbl(lower = 0.01, upper = 0.02),
    minsplit = paradox::p_int(lower = 1, upper = 2)),
  "ml_m" = paradox::ps(
    cp = paradox::p_dbl(lower = 0.01, upper = 0.02),
    minsplit = paradox::p_int(lower = 1, upper = 2)))

# minimum requirements for tune_settings
tune_settings = list(
  terminator = mlr3tuning::trm("evals", n_evals = 5),
  algorithm = mlr3tuning::tnr("grid_search", resolution = 5))
dml_irm_obj$tune(param_set = param_grid, tune_settings = tune_settings)
dml_irm_obj$fit()
dml_irm_obj$summary()
}

}
\seealso{
Other DoubleML: 
\code{\link{DoubleML}},
\code{\link{DoubleMLIIVM}},
\code{\link{DoubleMLPLIV}},
\code{\link{DoubleMLPLR}},
\code{\link{DoubleMLSSM}}
}
\concept{DoubleML}
\section{Super class}{
\code{\link[DoubleML:DoubleML]{DoubleML::DoubleML}} -> \code{DoubleMLIRM}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{trimming_rule}}{(\code{character(1)}) \cr
A \code{character(1)} specifying the trimming approach.}

\item{\code{trimming_threshold}}{(\code{numeric(1)}) \cr
The threshold used for timming.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DoubleMLIRM-new}{\code{DoubleMLIRM$new()}}
\item \href{#method-DoubleMLIRM-clone}{\code{DoubleMLIRM$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="DoubleML" data-topic="DoubleML" data-id="bootstrap"><a href='../../DoubleML/html/DoubleML.html#method-DoubleML-bootstrap'><code>DoubleML::DoubleML$bootstrap()</code></a></span></li>
<li><span class="pkg-link" data-pkg="DoubleML" data-topic="DoubleML" data-id="confint"><a href='../../DoubleML/html/DoubleML.html#method-DoubleML-confint'><code>DoubleML::DoubleML$confint()</code></a></span></li>
<li><span class="pkg-link" data-pkg="DoubleML" data-topic="DoubleML" data-id="fit"><a href='../../DoubleML/html/DoubleML.html#method-DoubleML-fit'><code>DoubleML::DoubleML$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="DoubleML" data-topic="DoubleML" data-id="get_params"><a href='../../DoubleML/html/DoubleML.html#method-DoubleML-get_params'><code>DoubleML::DoubleML$get_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="DoubleML" data-topic="DoubleML" data-id="learner_names"><a href='../../DoubleML/html/DoubleML.html#method-DoubleML-learner_names'><code>DoubleML::DoubleML$learner_names()</code></a></span></li>
<li><span class="pkg-link" data-pkg="DoubleML" data-topic="DoubleML" data-id="p_adjust"><a href='../../DoubleML/html/DoubleML.html#method-DoubleML-p_adjust'><code>DoubleML::DoubleML$p_adjust()</code></a></span></li>
<li><span class="pkg-link" data-pkg="DoubleML" data-topic="DoubleML" data-id="params_names"><a href='../../DoubleML/html/DoubleML.html#method-DoubleML-params_names'><code>DoubleML::DoubleML$params_names()</code></a></span></li>
<li><span class="pkg-link" data-pkg="DoubleML" data-topic="DoubleML" data-id="print"><a href='../../DoubleML/html/DoubleML.html#method-DoubleML-print'><code>DoubleML::DoubleML$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="DoubleML" data-topic="DoubleML" data-id="set_ml_nuisance_params"><a href='../../DoubleML/html/DoubleML.html#method-DoubleML-set_ml_nuisance_params'><code>DoubleML::DoubleML$set_ml_nuisance_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="DoubleML" data-topic="DoubleML" data-id="set_sample_splitting"><a href='../../DoubleML/html/DoubleML.html#method-DoubleML-set_sample_splitting'><code>DoubleML::DoubleML$set_sample_splitting()</code></a></span></li>
<li><span class="pkg-link" data-pkg="DoubleML" data-topic="DoubleML" data-id="split_samples"><a href='../../DoubleML/html/DoubleML.html#method-DoubleML-split_samples'><code>DoubleML::DoubleML$split_samples()</code></a></span></li>
<li><span class="pkg-link" data-pkg="DoubleML" data-topic="DoubleML" data-id="summary"><a href='../../DoubleML/html/DoubleML.html#method-DoubleML-summary'><code>DoubleML::DoubleML$summary()</code></a></span></li>
<li><span class="pkg-link" data-pkg="DoubleML" data-topic="DoubleML" data-id="tune"><a href='../../DoubleML/html/DoubleML.html#method-DoubleML-tune'><code>DoubleML::DoubleML$tune()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DoubleMLIRM-new"></a>}}
\if{latex}{\out{\hypertarget{method-DoubleMLIRM-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this R6 class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DoubleMLIRM$new(
  data,
  ml_g,
  ml_m,
  n_folds = 5,
  n_rep = 1,
  score = "ATE",
  trimming_rule = "truncate",
  trimming_threshold = 1e-12,
  dml_procedure = "dml2",
  draw_sample_splitting = TRUE,
  apply_cross_fitting = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{(\code{DoubleMLData}) \cr
The \code{DoubleMLData} object providing the data and specifying the variables
of the causal model.}

\item{\code{ml_g}}{(\code{\link[mlr3:LearnerRegr]{LearnerRegr}},
\code{\link[mlr3:LearnerClassif]{LearnerClassif}}, \code{\link[mlr3:Learner]{Learner}},
\code{character(1)}) \cr
A learner of the class \code{\link[mlr3:LearnerRegr]{LearnerRegr}}, which is
available from \href{https://mlr3.mlr-org.com/index.html}{mlr3} or its
extension packages \href{https://mlr3learners.mlr-org.com/}{mlr3learners} or
\href{https://mlr3extralearners.mlr-org.com/}{mlr3extralearners}.
For binary treatment outcomes, an object of the class
\code{\link[mlr3:LearnerClassif]{LearnerClassif}} can be passed, for example
\code{lrn("classif.cv_glmnet", s = "lambda.min")}.
Alternatively, a \code{\link[mlr3:Learner]{Learner}} object with public field
\code{task_type = "regr"} or \code{task_type = "classif"} can be passed,
respectively, for example of class
\code{\link[mlr3pipelines:mlr_learners_graph]{GraphLearner}}. \cr
\code{ml_g} refers to the nuisance function \eqn{g_0(X) = E[Y|X,D]}.}

\item{\code{ml_m}}{(\code{\link[mlr3:LearnerClassif]{LearnerClassif}},
\code{\link[mlr3:Learner]{Learner}}, \code{character(1)}) \cr
A learner of the class \code{\link[mlr3:LearnerClassif]{LearnerClassif}}, which is
available from \href{https://mlr3.mlr-org.com/index.html}{mlr3} or its
extension packages \href{https://mlr3learners.mlr-org.com/}{mlr3learners} or
\href{https://mlr3extralearners.mlr-org.com/}{mlr3extralearners}.
Alternatively, a \code{\link[mlr3:Learner]{Learner}} object with public field
\code{task_type = "classif"} can be passed, for example of class
\code{\link[mlr3pipelines:mlr_learners_graph]{GraphLearner}}. The learner can possibly
be passed with specified parameters, for example
\code{lrn("classif.cv_glmnet", s = "lambda.min")}. \cr
\code{ml_m} refers to the nuisance function \eqn{m_0(X) = E[D|X]}.}

\item{\code{n_folds}}{(\code{integer(1)})\cr
Number of folds. Default is \code{5}.}

\item{\code{n_rep}}{(\code{integer(1)}) \cr
Number of repetitions for the sample splitting. Default is \code{1}.}

\item{\code{score}}{(\code{character(1)}, \verb{function()}) \cr
A \code{character(1)} (\code{"ATE"} or \code{ATTE}) or a \verb{function()} specifying the
score function. If a \verb{function()}
is provided, it must be of the form
\verb{function(y, d, g0_hat, g1_hat, m_hat, smpls)} and the returned output
must be a named \code{list()} with elements \code{psi_a} and \code{psi_b}.
Default is \code{"ATE"}.}

\item{\code{trimming_rule}}{(\code{character(1)}) \cr
A \code{character(1)} (\code{"truncate"} is the only choice) specifying the
trimming approach. Default is \code{"truncate"}.}

\item{\code{trimming_threshold}}{(\code{numeric(1)}) \cr
The threshold used for timming. Default is \code{1e-12}.}

\item{\code{dml_procedure}}{(\code{character(1)}) \cr
A \code{character(1)} (\code{"dml1"} or \code{"dml2"}) specifying the double machine
learning algorithm. Default is \code{"dml2"}.}

\item{\code{draw_sample_splitting}}{(\code{logical(1)}) \cr
Indicates whether the sample splitting should be drawn during
initialization of the object. Default is \code{TRUE}.}

\item{\code{apply_cross_fitting}}{(\code{logical(1)}) \cr
Indicates whether cross-fitting should be applied. Default is \code{TRUE}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DoubleMLIRM-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DoubleMLIRM-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DoubleMLIRM$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
