% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/double_ml_data.R
\name{double_ml_data_from_matrix}
\alias{double_ml_data_from_matrix}
\title{Wrapper for Double machine learning data-backend initialization
from matrix.}
\usage{
double_ml_data_from_matrix(
  X = NULL,
  y,
  d,
  z = NULL,
  s = NULL,
  cluster_vars = NULL,
  data_class = "DoubleMLData",
  use_other_treat_as_covariate = TRUE
)
}
\arguments{
\item{X}{(\code{matrix()}) \cr
Matrix of covariates.}

\item{y}{(\code{numeric()}) \cr
Vector of outcome variable.}

\item{d}{(\code{matrix()}) \cr
Matrix of treatment variables.}

\item{z}{(\code{matrix()}) \cr
Matrix of instruments.}

\item{s}{(\code{numeric()}) \cr
Vector of the score or selection variable (only relevant for SSM models).}

\item{cluster_vars}{(\code{matrix()}) \cr
Matrix of cluster variables.}

\item{data_class}{(\code{character(1)}) \cr
Class of returned object. By default, an object of class \code{DoubleMLData} is
returned. Setting \code{data_class = "data.table"} returns an object of class
\code{data.table}.}

\item{use_other_treat_as_covariate}{(\code{logical(1)}) \cr
Indicates whether in the multiple-treatment case the other treatment
variables should be added as covariates. Default is \code{TRUE}.}
}
\value{
Creates a new instance of class \code{DoubleMLData}.
}
\description{
Initalization of DoubleMLData from \code{matrix()} objects.
}
\examples{
matrix_list = make_plr_CCDDHNR2018(return_type = "matrix")
obj_dml_data = double_ml_data_from_matrix(
  X = matrix_list$X,
  y = matrix_list$y,
  d = matrix_list$d)
}
