% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tESDFPerc.R
\name{tESDFPerc}
\alias{tESDFPerc}
\title{Percentiles of ES distribution function for t-distributed  P/L}
\usage{
tESDFPerc(...)
}
\arguments{
\item{...}{The input arguments contain either return data or else mean and
standard deviation data. Accordingly, number of input arguments is either 5
or 7. In case there 5 input arguments, the mean, standard deviation and assumed sampel size of
data is computed from return data. See examples for details.

 returns Vector of daily geometric return data

 mu Mean of daily geometric return data

 sigma Standard deviation of daily geometric return data

 n Sample size

 df Degrees of freedom

 perc Desired percentile

 df Number of degrees of freedom in the t distribution

 cl ES confidence level and must be a scalar

 hp ES holding period and must be a a scalar}
}
\value{
Percentiles of ES distribution function
}
\description{
Estimates percentiles of ES distribution function for t-distributed P/L,
using the theory of order statistics
}
\examples{
# Estimates Percentiles of ES distribution given P/L data
   data <- runif(5, min = 0, max = .2)
   tESDFPerc(returns = data, perc = .7, df = 6, cl = .95, hp = 60)

   # Estimates Percentiles of ES distribution given mean, std. deviation and sample size
   tESDFPerc(mu = .012, sigma = .03, n= 10, perc = .8, df = 6, cl = .99, hp = 40)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

