% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tVaR.R
\name{tVaR}
\alias{tVaR}
\title{VaR for t distributed P/L}
\usage{
tVaR(...)
}
\arguments{
\item{...}{The input arguments contain either return data or else mean and
 standard deviation data. Accordingly, number of input arguments is either 4
 or 5. In case there 4 input arguments, the mean and standard deviation of
 data is computed from return data. See examples for details.

 returns Vector of daily geometric return data

 mu Mean of daily geometric return data

 sigma Standard deviation of daily geometric return data

 df Number of degrees of freedom in the t distribution

 cl VaR confidence level

 hp VaR holding period}
}
\value{
Matrix of VaRs whose dimension depends on dimension of hp and cl. If
cl and hp are both scalars, the matrix is 1 by 1. If cl is a vector and hp is
 a scalar, the matrix is row matrix, if cl is a scalar and hp is a vector,
 the matrix is column matrix and if both cl and hp are vectors, the matrix
 has dimension length of cl * length of hp.
}
\description{
Estimates the VaR of a portfolio assuming that P/L are
t distributed, for specified confidence level and holding period.
}
\examples{
# Computes VaR given P/L data
   data <- runif(5, min = 0, max = .2)
   tVaR(returns = data, df = 6, cl = .95, hp = 90)

   # Computes VaR given mean and standard deviation of P/L data
   tVaR(mu = .012, sigma = .03, df = 6, cl = .95, hp = 90)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.

Evans, M., Hastings, M. and Peacock, B. Statistical Distributions, 3rd
edition, New York: John Wiley, ch. 38,39.
}

