% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{check_input}
\alias{check_input}
\title{Check pipeline input data for required format}
\usage{
check_input(layers, inter_layer_connections, drug_target_interactions)
}
\arguments{
\item{layers}{[list] List of layers to check. Individual layers were created by
\code{\link[DrDimont]{make_layer}} and need to be wrapped in a list.}

\item{inter_layer_connections}{[list] A list containing connections between layers. Each
connection was created by \code{\link[DrDimont]{make_connection}} and wrapped in a list.}

\item{drug_target_interactions}{[list] A named list of the drug interaction data. Created by
\code{\link[DrDimont]{make_drug_target}}}
}
\value{
Character string vector containing error messages.
}
\description{
Checks if input data is valid and formatted correctly. This function is a
wrapper for other check functions to be executed as the first step of the DrDimont pipeline.
}
\examples{
data(layers_example)
data(metabolite_protein_interactions)
data(drug_gene_interactions)
data

all_layers <- layers_example

all_inter_layer_connections = list(
    make_connection(from='mrna', to='protein', connect_on='gene_name', weight=1),
    make_connection(from='protein', to='phosphosite', connect_on='gene_name', weight=1),
    make_connection(from='protein', to='metabolite',
    connect_on=metabolite_protein_interactions, weight='combined_score'))

all_drug_target_interactions <- make_drug_target(
                                    target_molecules="protein",
                                    interaction_table=drug_gene_interactions,
                                    match_on="gene_name")

return_errors(check_input(layers=all_layers,
    inter_layer_connections=all_inter_layer_connections,
    drug_target_interactions=all_drug_target_interactions))

}
